/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.Bookmark;
import edu.sdsc.secureftp.data.BookmarkVector;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.EditBookmarksPanel;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;

public class EditBookmarksDialog
extends JDialog
implements Constants {
    private SecureFtpApplet parent;
    private GridBagConstraints gbc = new GridBagConstraints();
    private EditBookmarksPanel bookmarksPanel;
    private JPanel buttonPanel;
    private JButton editButton;
    private JButton deleteButton;
    private JButton closeButton;
    private JButton upButton;
    private JButton downButton;

    public EditBookmarksDialog(SecureFtpApplet secureFtpApplet) {
        super(secureFtpApplet.getBaseFrame(), new LString("edit_bookmarks.title", "Edit Bookmarks").getString(), true);
        this.parent = secureFtpApplet;
        this.getContentPane().setLayout(new BorderLayout());
        this.bookmarksPanel = new EditBookmarksPanel(this.parent);
        this.bookmarksPanel.setBackground(Color.white);
        this.addBookmarks();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.getButtons();
        this.addButtonListeners();
        this.getContentPane().add((Component)this.bookmarksPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.bookmarksPanel.setPreferredSize(new Dimension(200, 350));
        this.pack();
        this.setLocationRelativeTo(this.parent.getContentPane());
        ((Component)this).setVisible(true);
        this.setResizable(false);
    }

    protected void addBookmarks() {
        BookmarkVector bookmarkVector = this.parent.getBookmarks();
        int n2 = bookmarkVector.size();
        int n3 = 0;
        while (n3 < n2) {
            Bookmark bookmark = (Bookmark)bookmarkVector.elementAt(n3);
            debug.println("bookmarks: " + bookmark.getName() + " - " + bookmark.getHostname() + " - " + bookmark.getUsername(), 4);
            this.bookmarksPanel.buildRow(bookmark.getName(), bookmark.getHostname(), bookmark.getUsername());
            ++n3;
        }
    }

    protected void addButtonListeners() {
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n2 = EditBookmarksDialog.this.bookmarksPanel.getSelectedIndex();
                EditBookmarksDialog.this.bookmarksPanel.moveRow(n2, n2 - 1);
            }
        });
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n2 = EditBookmarksDialog.this.bookmarksPanel.getSelectedIndex();
                EditBookmarksDialog.this.bookmarksPanel.moveRow(n2, n2 + 1);
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditBookmarksDialog.this.bookmarksPanel.editSelectedRow();
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditBookmarksDialog.this.bookmarksPanel.removeSelectedRow();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditBookmarksDialog.this.dispose();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    EditBookmarksDialog.this.dispose();
                }
            }
        });
    }

    protected void getButtons() {
        if (this.upButton == null) {
            this.upButton = new JButton(new LString("edit_bookmarks.up_button.label", "Up").getString());
        }
        if (this.downButton == null) {
            this.downButton = new JButton(new LString("edit_bookmarks.down_button.label", "Down").getString());
        }
        if (this.editButton == null) {
            this.editButton = new JButton(new LString("edit_bookmarks.edit_button.label", "Edit Bookmark").getString());
        }
        if (this.deleteButton == null) {
            this.deleteButton = new JButton(new LString("edit_bookmarks.delete_button.label", "Delete Bookmark").getString());
        }
        if (this.closeButton == null) {
            this.closeButton = new JButton(new LString("close_button.label", "Close").getString());
        }
        this.buttonPanel.add(this.upButton);
        this.buttonPanel.add(this.downButton);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.editButton);
        this.buttonPanel.add(this.deleteButton);
        this.buttonPanel.add(Box.createHorizontalStrut(5));
        this.buttonPanel.add(this.closeButton);
    }

    protected GridBagConstraints getGBC(int n2, int n3, double d10, double d11, int n4, int n5, int n6, int n7) {
        this.gbc.fill = n2;
        this.gbc.anchor = n3;
        this.gbc.weightx = d10;
        this.gbc.weighty = d11;
        this.gbc.gridx = n4;
        this.gbc.gridy = n5;
        this.gbc.gridwidth = n6;
        this.gbc.gridheight = n7;
        return this.gbc;
    }

    protected void unSetEnterEvent(JTextField jTextField) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        Keymap keymap = jTextField.getKeymap();
        keymap.removeKeyStrokeBinding(keyStroke);
    }
}

