/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.Bookmark;
import edu.sdsc.secureftp.gui.ConnectionInfoDialog;
import edu.sdsc.secureftp.gui.ErrorDialog;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class EditBookmarkDialog
extends ConnectionInfoDialog
implements Constants {
    private JTextField profileNameTextField;
    private JButton cancelButton;
    private JButton okButton;

    public EditBookmarkDialog(SecureFtpApplet secureFtpApplet, Bookmark bookmark) {
        super(secureFtpApplet, bookmark, new LString("edit_bookmark.title", "Edit Bookmark").getString(), true);
        this.setResizable(false);
    }

    protected void addButtonListeners() {
        SwingUtilities.getRootPane(this).setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!EditBookmarkDialog.this.profileNameTextField.getText().trim().equals("") && !EditBookmarkDialog.this.hostNameTextField.getText().trim().equals("")) {
                    EditBookmarkDialog.this.editBookmark();
                    EditBookmarkDialog.this.dispose();
                } else {
                    EditBookmarkDialog.this.getToolkit().beep();
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditBookmarkDialog.this.dispose();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!EditBookmarkDialog.this.profileNameTextField.getText().trim().equals("") && !EditBookmarkDialog.this.hostNameTextField.getText().trim().equals("")) {
                        EditBookmarkDialog.this.editBookmark();
                        EditBookmarkDialog.this.dispose();
                    } else {
                        EditBookmarkDialog.this.getToolkit().beep();
                    }
                } else if (keyEvent.getKeyCode() == 27) {
                    EditBookmarkDialog.this.dispose();
                }
            }
        });
    }

    protected void addButtons() {
        if (this.okButton == null) {
            this.okButton = new JButton(new LString("ok_button.label", "OK").getString());
        }
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(new LString("cancel_button.label", "Cancel").getString());
        }
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
    }

    public void addNotify() {
        super.addNotify();
        this.getProfileNameTextField().requestFocus();
        this.getProfileNameTextField().selectAll();
    }

    protected void editBookmark() {
        this.bookmark.setName(this.getProfileNameTextField().getText());
        this.bookmark.setHostname(this.getHostNameTextField().getText());
        this.bookmark.setUsername(this.getUserNameTextField().getText());
        this.bookmark.setPort(this.getPortTextField().getText());
        this.bookmark.setSecurity(this.getSecurityChoice().getSelectedIndex());
        this.bookmark.setAnon(this.getAnonCheckBox().isSelected());
        this.bookmark.setPasv(this.getPasvCheckBox().isSelected());
        this.bookmark.setSSLData(this.getEncryptionCheckBox().isSelected());
        this.bookmark.setProxy(this.getProxyCheckBox().isSelected());
        try {
            this.parent.getBookmarks().writeToDisk();
        }
        catch (IOException iOException) {
            new ErrorDialog(iOException.getMessage(), new LString("failed_to_write_bookmarks.msg", "Failed to write bookmarks").getString());
        }
    }

    protected JPanel getMainPanel() {
        if (this.mainPanel == null) {
            JLabel jLabel;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setPreferredSize(new Dimension(300, 180));
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            String string = new LString("connection_info.profile.label", "Profile").getString();
            String string2 = new LString("connection_info.hostname.label", "Hostname").getString();
            String string3 = new LString("connection_info.username.label", "Username").getString();
            boolean bl2 = false;
            int n2 = this.getFont().getSize();
            while (!bl2 && n2 >= 8) {
                jLabel = new JLabel("");
                this.setFont(new Font(jLabel.getFont().getFontName(), jLabel.getFont().getStyle(), n2));
                fontMetrics = this.getFontMetrics(this.getFont());
                int n3 = fontMetrics.stringWidth(string);
                int n4 = fontMetrics.stringWidth(string2);
                int n5 = fontMetrics.stringWidth(string3);
                if (n4 < 102 && n5 < 102 && n3 < 102) {
                    bl2 = true;
                }
                --n2;
            }
            jLabel = new JLabel("  " + string + ":");
            jLabel.setFont(this.getFont());
            this.mainPanel.add((Component)jLabel, this.getGBC(0, 16, 0.3, 1.0, 0, 0, 1, 2));
            this.mainPanel.add((Component)this.getProfileNameTextField(), this.getGBC(0, 16, 0.7, 0.0, 1, 1, 4, 1));
            JLabel jLabel2 = new JLabel("  " + string2 + ":");
            jLabel2.setFont(this.getFont());
            this.mainPanel.add((Component)jLabel2, this.getGBC(0, 16, 0.3, 1.0, 0, 2, 1, 2));
            this.mainPanel.add((Component)this.getHostNameTextField(), this.getGBC(0, 16, 0.7, 0.0, 1, 3, 4, 1));
            JLabel jLabel3 = new JLabel("  " + string3 + ":");
            jLabel3.setFont(this.getFont());
            this.mainPanel.add((Component)jLabel3, this.getGBC(0, 16, 0.3, 1.0, 0, 4, 1, 2));
            this.mainPanel.add((Component)this.getUserNameTextField(), this.getGBC(0, 16, 0.7, 0.0, 1, 5, 4, 1));
            this.mainPanel.add((Component)this.getAnonCheckBox(), this.getGBC(0, 17, 0.3, 1.0, 1, 6, 1, 1));
        }
        if (!System.getProperty("java.version").startsWith("1.2")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditBookmarkDialog.this.getProfileNameTextField().requestFocus();
                    EditBookmarkDialog.this.setResizable(false);
                }
            });
        }
        return this.mainPanel;
    }

    protected JTextField getProfileNameTextField() {
        if (this.profileNameTextField == null) {
            this.profileNameTextField = new JTextField(15);
            this.unSetEnterEvent(this.profileNameTextField);
        }
        return this.profileNameTextField;
    }

    protected void setupDefaults() {
        this.getAnonCheckBox().setSelected(this.bookmark.getAnon());
        this.getProfileNameTextField().setText(this.bookmark.getName());
        this.getHostNameTextField().setText(this.bookmark.getHostname());
        this.getSecurityChoice().setSelectedIndex(this.bookmark.getSecurity());
        this.getPortTextField().setText(this.bookmark.getPort());
        this.getPasvCheckBox().setSelected(this.bookmark.getPasv());
        this.getEncryptionCheckBox().setSelected(this.bookmark.getSSLData());
        this.getProxyCheckBox().setSelected(this.bookmark.getProxy());
        this.getProxyCheckBox().setEnabled(true);
        this.getUserNameTextField().setText(this.bookmark.getUsername());
    }
}

