/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.data.DropObject;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.ListPanel;
import edu.sdsc.secureftp.gui.TransferTable;
import java.awt.Color;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class DropTable
extends JTable
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private DropTarget dropTarget = new DropTarget(this, this);
    private DragSource dragSource = DragSource.getDefaultDragSource();
    private ListPanel parent;

    public DropTable(ListPanel listPanel, DefaultTableModel defaultTableModel) {
        this(defaultTableModel);
        this.parent = listPanel;
    }

    public DropTable(DefaultTableModel defaultTableModel) {
        super(defaultTableModel);
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.parent.parent.initialFrame = null;
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            if (this.parent.parent.initialFrame != null && !this.parent.parent.initialFrame.equals(this.parent.getName())) {
                dropTargetDragEvent.acceptDrag(3);
            }
        } else {
            debug.println("drag rejected");
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.parent.parent.initialFrame != null && !this.parent.parent.initialFrame.equals(this.parent.getName())) {
            this.clearSelection();
            this.parent.scrollPane.requestFocus();
            this.parent.scrollPane.setViewportBorder(BorderFactory.createLineBorder(Color.white));
            this.parent.scrollPane.updateUI();
        }
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        DropObject dropObject = new DropObject(this.parent.getName(), this.parent.getSelectedEntries());
        TransferTable transferTable = new TransferTable(dropObject);
        dragGestureEvent.startDrag(DragSource.DefaultCopyDrop, transferTable, this);
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        if (this.parent.parent.initialFrame == null) {
            this.parent.parent.initialFrame = this.parent.getName();
            debug.println("initial frame drag from " + this.parent.parent.initialFrame);
        }
        try {
            if (!this.parent.parent.initialFrame.equals(this.parent.getName()) && this.rowAtPoint(dropTargetDragEvent.getLocation()) != 0) {
                String string = (String)this.getValueAt(this.rowAtPoint(dropTargetDragEvent.getLocation()), 1);
                if (string != null && this.parent.dirStruct.get(string).equals("d")) {
                    this.setRowSelectionInterval(this.rowAtPoint(dropTargetDragEvent.getLocation()), this.rowAtPoint(dropTargetDragEvent.getLocation()));
                } else {
                    this.clearSelection();
                    this.parent.scrollPane.requestFocus();
                }
                this.parent.scrollPane.setViewportBorder(BorderFactory.createLineBorder(SystemColor.desktop));
                this.parent.scrollPane.updateUI();
            } else if (!this.parent.parent.initialFrame.equals(this.parent.getName())) {
                this.clearSelection();
                this.parent.scrollPane.requestFocus();
                this.parent.scrollPane.setViewportBorder(BorderFactory.createLineBorder(SystemColor.desktop));
                this.parent.scrollPane.updateUI();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (!this.parent.parent.initialFrame.equals(this.parent.getName())) {
                this.clearSelection();
            }
            this.parent.scrollPane.requestFocus();
        }
    }

    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            debug.println("file dropped");
            this.parent.parent.initialFrame = null;
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dropTargetDropEvent.acceptDrop(3);
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                DropObject dropObject = (DropObject)TransferTable.dropObjHash.get(string);
                if (dropObject != null && !dropObject.getOwner().equals(this.parent.getName())) {
                    this.parent.handleDrop(dropObject.getFiles(), dropTargetDropEvent.getLocation());
                }
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                debug.println("drop rejected");
                this.parent.parent.initialFrame = null;
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (IOException iOException) {
            this.parent.parent.initialFrame = null;
            debug.println("io exception: drop rejected");
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            this.parent.parent.initialFrame = null;
            debug.println("unsupported flavor exception: drop rejected");
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    protected ListPanel getListPanel() {
        return this.parent;
    }
}

