/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.gui.DropTable;
import edu.sdsc.secureftp.gui.ListPanel;
import java.awt.Color;
import java.awt.SystemColor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class DropListViewport
extends JViewport
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private DropTarget dropTarget = new DropTarget(this, this);
    private DragSource dragSource = DragSource.getDefaultDragSource();
    private ListPanel list;
    private JScrollPane pane;

    public DropListViewport(JScrollPane jScrollPane, ListPanel listPanel) {
        this.list = listPanel;
        this.pane = jScrollPane;
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DropListViewport.this.getDropTable().clearSelection();
                DropListViewport.this.requestFocus();
            }
        });
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.pane.setViewportBorder(BorderFactory.createLineBorder(Color.white));
        this.pane.updateUI();
        this.getDropTable().dragDropEnd(dragSourceDropEvent);
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.getDropTable().dragEnter(dropTargetDragEvent);
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.pane.setViewportBorder(BorderFactory.createLineBorder(Color.white));
        this.pane.updateUI();
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        this.getDropTable().dragGestureRecognized(dragGestureEvent);
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.getListPanel().parent.initialFrame != null && !this.getListPanel().parent.initialFrame.equals(this.getListPanel().getName())) {
            this.pane.setViewportBorder(BorderFactory.createLineBorder(SystemColor.desktop));
            this.pane.updateUI();
        }
        this.getDropTable().dragOver(dropTargetDragEvent);
    }

    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.getDropTable().drop(dropTargetDropEvent);
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private DropTable getDropTable() {
        return this.list.tableView;
    }

    private ListPanel getListPanel() {
        return this.list;
    }
}

