/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.data;

import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import com.sun.net.ssl.X509TrustManager;
import edu.sdsc.secureftp.data.Data;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.LString;
import java.awt.Font;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SecureFtpTrustManager
implements X509TrustManager {
    Data data;
    private Object[] buttonRow = new Object[]{new LString("continue_button.label", "Continue").getString(), new LString("cancel_button.label", "Cancel").getString()};

    public SecureFtpTrustManager(Data data) {
        this.data = data;
    }

    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
        return true;
    }

    public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
        if (!this.data.getCertificateCheck()) {
            return true;
        }
        LString lString = new LString("unknown.msg", "unknown");
        String string = "<" + lString.getString() + ">";
        String string2 = "<" + lString.getString() + ">";
        try {
            Object object;
            X509Certificate x509Certificate;
            block16: {
                if (x509CertificateArray == null || x509CertificateArray.length < 1 || x509CertificateArray[0] == null) {
                    return this.showContinueDialog(new LString("ssl.server_no_cert.msg", "Server did not send a certificate.").getString(), new LString("ssl.server_no_cert.title", "No Certificate").getString());
                }
                x509Certificate = x509CertificateArray[0];
                this.data.startSSLConnection(x509Certificate);
                try {
                    x509Certificate.checkValidity();
                }
                catch (CertificateExpiredException certificateExpiredException) {
                    if (!this.showContinueDialog(new LString("ssl.server_cert_expired.msg", "Server certificate has expired.").getString(), new LString("ssl.server_cert_expired.title", "Certificate Expired").getString())) {
                        return false;
                    }
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    if (this.showContinueDialog(new LString("ssl.server_cert_not_valid.msg", "Server certificate is not yet valid.").getString(), new LString("ssl.server_cert_not_valid.title", "Certificate Not Yet Valid").getString())) break block16;
                    return false;
                }
            }
            Perl5Compiler perl5Compiler = new Perl5Compiler();
            Perl5Matcher perl5Matcher = new Perl5Matcher();
            try {
                object = perl5Compiler.compile("cn=([-\\w.]+)", 1);
                if (perl5Matcher.contains(x509Certificate.getSubjectDN().getName(), (Pattern)object)) {
                    string = perl5Matcher.getMatch().group(1);
                }
            }
            catch (MalformedPatternException malformedPatternException) {
                debug.println("pattern exception: " + malformedPatternException.getMessage());
            }
            catch (NullPointerException nullPointerException) {}
            string2 = this.data.getHostname();
            object = InetAddress.getByName(string);
            InetAddress inetAddress = InetAddress.getByName(string2);
            debug.println("cnAddr => " + object + ", hostAddr => " + inetAddress);
            if (!string.equals(string2) && !((InetAddress)object).getHostAddress().equals(inetAddress.getHostAddress())) {
                LString lString2 = new LString("ssl.cert_does_not_match.msg", "The hostname \"[^0]\" does not match certificate name \"[^1]\".");
                lString2.replace(0, string2);
                lString2.replace(1, string);
                if (!this.showContinueDialog(lString2.getString(), new LString("ssl.cert_does_not_match.title", "Common Name Does Not Match").getString())) {
                    return false;
                }
            }
            if (this.data.getFtpKeyStore().findCertificate(x509Certificate)) {
                return true;
            }
            return this.data.trustNewCertificate(x509Certificate);
        }
        catch (UnknownHostException unknownHostException) {
            LString lString3 = new LString("ssl.cert_does_not_match.msg", "The hostname \"[^0]\" does not match certificate name \"[^1]\".");
            lString3.replace(0, string2);
            lString3.replace(1, string);
            return this.showContinueDialog(lString3.getString(), new LString("ssl.cert_does_not_match.title", "Common Name Does Not Match").getString());
        }
        catch (Exception exception) {
            debug.println("Exception in trust manager: " + exception.getMessage());
            return false;
        }
    }

    private boolean showContinueDialog(String string, String string2) {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Dialog", 0, 10));
        jPanel.add(jLabel);
        int n2 = JOptionPane.showOptionDialog(null, jPanel, string2, 0, 2, null, this.buttonRow, this.buttonRow[0]);
        return n2 == 0;
    }
}

