/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.data;

import edu.sdsc.secureftp.debug;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;

public class FtpKeyStore {
    KeyStore keyStore = null;
    String filename;
    char[] password;

    public FtpKeyStore(String string, char[] cArray) throws Exception {
        this.filename = string;
        this.password = cArray;
        this.keyStore = KeyStore.getInstance("JKS");
        this.readKeyStore();
    }

    public void addCertificate(X509Certificate x509Certificate) {
        try {
            this.keyStore.setCertificateEntry(x509Certificate.getSubjectDN().toString(), x509Certificate);
        }
        catch (Exception exception) {
            debug.println("Add certificate exception: " + exception.getMessage());
        }
    }

    public boolean findCertificate(X509Certificate x509Certificate) {
        try {
            return this.keyStore != null && this.keyStore.getCertificateAlias(x509Certificate) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public boolean lookupAlias(X509Certificate x509Certificate) {
        try {
            String string = x509Certificate.getSubjectDN().toString();
            return this.keyStore != null && this.keyStore.getCertificate(string) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void readKeyStore() throws Exception {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            debug.println("No keystore file found, using null");
        }
        catch (Exception exception) {
            debug.println("Read key store exception: " + exception.getMessage());
        }
        this.keyStore.load(fileInputStream, this.password);
        if (fileInputStream != null) {
            fileInputStream.close();
        }
    }

    public void removeCertificate(X509Certificate x509Certificate) {
        try {
            this.keyStore.deleteEntry(x509Certificate.getSubjectDN().toString());
        }
        catch (Exception exception) {
            debug.println("Add certificate exception: " + exception.getMessage());
        }
    }

    public void writeKeyStore() {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.filename);
            this.keyStore.store(fileOutputStream, this.password);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            debug.println("Write key store exception: " + exception.getMessage());
        }
    }
}

