/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.data;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.FileEntry;
import edu.sdsc.secureftp.data.FtpThread;
import edu.sdsc.secureftp.data.NotADirectoryException;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.ErrorDialog;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import edu.sdsc.secureftp.network.BasicFtp;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import javax.swing.JOptionPane;

public class FtpGet
extends FtpThread
implements Constants {
    private static final int YES_OPTION = 0;
    private static final int YES_TO_ALL_OPTION = 1;
    private static final int NO_OPTION = 2;
    private static final int CANCEL_OPTION = 3;
    private SecureFtpApplet gui;
    private FileEntry[] fileList;
    private String transferMode;
    private boolean confirmOverwrite;
    private BasicFtp ftp;

    public FtpGet(SecureFtpApplet secureFtpApplet, FileEntry fileEntry, String string) {
        super(secureFtpApplet, string);
        this.gui = secureFtpApplet;
        this.fileList = new FileEntry[]{fileEntry};
        this.transferMode = string;
        this.ftp = this.gui.getFtpNet();
    }

    public FtpGet(SecureFtpApplet secureFtpApplet, FileEntry[] fileEntryArray, String string) {
        super(secureFtpApplet, string);
        this.gui = secureFtpApplet;
        this.fileList = fileEntryArray;
        this.transferMode = string;
        this.ftp = this.gui.getFtpNet();
    }

    public boolean changeDestDir(String string) throws NotADirectoryException {
        return this.changeLocalDir(string);
    }

    public boolean changeSourceDir(String string) throws NotADirectoryException {
        return this.changeFtpDir(string);
    }

    public boolean doTransfer(String string, String string2, long l2) {
        boolean bl2 = true;
        boolean bl3 = true;
        try {
            File file = new File(string2).getAbsoluteFile();
            if (file.isFile() && this.confirmOverwrite) {
                int n2 = 0;
                n2 = this.fileList.length == 1 && this.fileList[0].getType() == 'f' ? this.showOverwriteDialog(string2) : this.showMultiOverwriteDialog(string2);
                if (n2 == 1) {
                    this.confirmOverwrite = false;
                } else if (n2 == 3) {
                    bl2 = false;
                    bl3 = false;
                } else if (n2 != 0) {
                    bl3 = false;
                }
            }
            if (bl3) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                this.ftp.get(string, fileOutputStream, l2);
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            new ErrorDialog(String.valueOf(string2) + ": " + exception.getMessage(), new LString("download_failed.title", "Download Failed").getString());
            debug.println("Download failed: " + exception.getMessage());
            bl2 = false;
        }
        return bl2;
    }

    public String getDestDir() {
        return this.getLocalDir();
    }

    public Enumeration getDirContents() {
        return this.ftp.getClientData().getFileList().elements();
    }

    public String getLabelCaption() {
        return String.valueOf(new LString("downloading_file.msg", "Downloading file").getString()) + ":";
    }

    public String getSourceDir() {
        return this.getFtpDir();
    }

    public void run() {
        boolean bl2 = true;
        try {
            try {
                this.confirmOverwrite = true;
                this.gui.setNetworkStatus(2);
                int n2 = 0;
                while (n2 < this.fileList.length && bl2) {
                    FileEntry fileEntry = this.fileList[n2];
                    String string = new File(fileEntry.getName()).getName();
                    bl2 = this.startTransfer(fileEntry.getName(), string, fileEntry.getSize(), fileEntry.getType());
                    ++n2;
                }
            }
            catch (Exception exception) {
                debug.println(exception.getMessage());
            }
            Object var3_6 = null;
            this.gui.setNetworkStatus(0);
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.gui.setNetworkStatus(0);
            throw throwable;
        }
        this.ftp.getClientData().endFileTransfer(2);
    }

    private int showMultiOverwriteDialog(String string) {
        LString lString = new LString("file_exists.msg", "File [^0] exists. Overwrite?");
        lString.replace(0, string);
        LString lString2 = new LString("yes_button.label", "Yes");
        LString lString3 = new LString("yes_to_all_button.label", "Yes to All");
        LString lString4 = new LString("no_button.label", "No");
        LString lString5 = new LString("cancel_button.label", "Cancel");
        Object[] objectArray = new Object[]{lString2.getString(), lString3.getString(), lString4.getString(), lString5.getString()};
        int n2 = JOptionPane.showOptionDialog(null, lString.getString(), new LString("file_exists.title", "File exists").getString(), -1, 3, null, objectArray, objectArray[0]);
        return n2;
    }

    private int showOverwriteDialog(String string) {
        LString lString = new LString("file_exists.msg", "File [^0] exists. Overwrite?");
        lString.replace(0, string);
        LString lString2 = new LString("yes_button.label", "Yes");
        LString lString3 = new LString("no_button.label", "No");
        Object[] objectArray = new Object[]{lString2.getString(), lString3.getString()};
        int n2 = JOptionPane.showOptionDialog(null, lString.getString(), new LString("file_exists.title", "File exists").getString(), -1, 3, null, objectArray, objectArray[0]);
        switch (n2) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        return n2;
    }
}

