/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.data;

import edu.sdsc.secureftp.data.DeleteException;
import edu.sdsc.secureftp.data.FileEntry;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.ErrorDialog;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import edu.sdsc.secureftp.network.BasicFtp;
import edu.sdsc.secureftp.network.exception.FtpException;
import edu.sdsc.secureftp.network.exception.FtpNotADirectoryException;
import java.util.Enumeration;

public class FtpDelete {
    private SecureFtpApplet gui;
    private BasicFtp ftp;
    private boolean error;

    public FtpDelete(SecureFtpApplet secureFtpApplet, String string, char c10) throws FtpException {
        this.gui = secureFtpApplet;
        this.ftp = this.gui.getFtpNet();
        this.error = false;
        try {
            this.delete(string, c10);
            if (this.error) {
                throw new DeleteException(new LString("cannot_delete_some_items.msg", "Some items could not be deleted").getString());
            }
        }
        catch (DeleteException deleteException) {
            new ErrorDialog(deleteException.getMessage(), new LString("delete_failed.title", "Delete Failed").getString());
        }
    }

    public FtpDelete(SecureFtpApplet secureFtpApplet, FileEntry[] fileEntryArray) throws FtpException {
        this.gui = secureFtpApplet;
        this.ftp = this.gui.getFtpNet();
        this.error = false;
        try {
            int n2 = 0;
            while (n2 < fileEntryArray.length) {
                this.delete(fileEntryArray[n2].getName(), fileEntryArray[n2].getType());
                ++n2;
            }
            if (this.error) {
                throw new DeleteException(new LString("cannot_delete_some_items.msg", "Some items could not be deleted").getString());
            }
        }
        catch (DeleteException deleteException) {
            new ErrorDialog(deleteException.getMessage(), new LString("delete_failed.title", "Delete Failed").getString());
        }
    }

    private void changeDirectory(String string) throws FtpException {
        this.ftp.chdir(string);
        this.ftp.pwd();
        this.gui.getServerFrame().getDirTextField().setText(this.ftp.getDirName());
    }

    private void delete(String string, char c10) throws DeleteException, FtpException {
        if (string.equals(".") || string.equals("..")) {
            return;
        }
        if (c10 == 'f') {
            debug.println("delete remote file: " + string);
            try {
                this.ftp.delete(string);
            }
            catch (FtpException ftpException) {
                this.error = true;
            }
        } else {
            debug.println("delete remote directory: " + string);
            String string2 = this.ftp.getDirName();
            try {
                this.changeDirectory(string);
                this.listDirectory();
            }
            catch (FtpNotADirectoryException ftpNotADirectoryException) {
                this.delete(string, 'f');
                return;
            }
            catch (FtpException ftpException) {
                try {
                    this.ftp.rmdir(string);
                }
                catch (Exception exception) {
                    this.error = true;
                }
                return;
            }
            Enumeration enumeration = this.ftp.getClientData().getFileList().elements();
            while (enumeration.hasMoreElements()) {
                FileEntry fileEntry = (FileEntry)enumeration.nextElement();
                String string3 = fileEntry.getName();
                if (string3.equals(".") || string3.equals("..")) continue;
                this.delete(string3, fileEntry.getType());
            }
            try {
                if (string2 != null) {
                    this.changeDirectory(string2);
                }
            }
            catch (FtpException ftpException) {
                throw new DeleteException(new LString("remote_dir_out_of_sync.msg", "Remote directory is out of sync").getString());
            }
            try {
                this.ftp.rmdir(string);
            }
            catch (FtpException ftpException) {
                this.error = true;
            }
        }
    }

    private void listDirectory() throws FtpException {
        this.ftp.list();
    }
}

