/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.data;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.FileEntry;
import edu.sdsc.secureftp.data.FtpKeyStore;
import edu.sdsc.secureftp.data.HostInfo;
import edu.sdsc.secureftp.gui.FtpSecurityPanel;
import edu.sdsc.secureftp.gui.NewCertificateDialog;
import edu.sdsc.secureftp.gui.SSLSecurityPanel;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import edu.sdsc.secureftp.network.SSLInit;
import java.io.File;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.swing.JPanel;

public class Data
implements Constants {
    private SecureFtpApplet gui;
    private HostInfo hostInfo;
    private JPanel securityInfoPanel;
    private X509Certificate certificate;
    private Vector fileList;
    private FtpKeyStore ftpKeyStore;
    private boolean checkCert;
    private long transferSizeCompleted;
    private long transferSizeTotal;
    public static final int REFRESH_BOTH = 0;
    public static final int REFRESH_SERVER = 1;
    public static final int REFRESH_LOCAL = 2;

    public Data(SecureFtpApplet secureFtpApplet) {
        this.gui = secureFtpApplet;
        this.hostInfo = null;
        this.securityInfoPanel = null;
        this.fileList = null;
        this.ftpKeyStore = null;
        this.transferSizeCompleted = 0L;
        this.transferSizeTotal = -1L;
    }

    public void addDirEntry(String string, String string2, String string3, String string4) {
        long l2;
        char c10;
        if (string == null) {
            string = "?";
        }
        if (string2 == null) {
            string2 = "-";
        }
        if (string3 == null) {
            string3 = "-";
        }
        if (string4 == null) {
            string4 = "-";
        }
        if (string.charAt(0) == 'l' && (c10 = string2.indexOf(" -> ")) > '\u0000') {
            string2 = string2.substring(0, c10);
        }
        if ((c10 = (char)string.charAt(0)) == '-') {
            c10 = 'f';
        }
        this.gui.getServerPanel().buildRow(String.valueOf(c10), string2, string3, string4);
        try {
            l2 = Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            l2 = -1L;
        }
        this.fileList.add(new FileEntry(c10, l2, string2));
    }

    public void endDirEntry() {
        this.gui.getServerPanel().repaint();
    }

    public void endFileTransfer(int n2) {
        if (n2 == 0 || n2 == 2) {
            this.gui.getLocalUtil().list();
        }
        if (n2 == 0 || n2 == 1) {
            this.gui.getServerUtil().list();
        }
        this.gui.getTransferStatusDialog().dispose();
        this.transferSizeCompleted = 0L;
        this.transferSizeTotal = -1L;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public boolean getCertificateCheck() {
        return this.checkCert;
    }

    public Vector getFileList() {
        return this.fileList;
    }

    public FtpKeyStore getFtpKeyStore() {
        return this.ftpKeyStore;
    }

    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    public String getHostname() {
        return (String)this.hostInfo.get("hostname");
    }

    public SSLInit getSSLInit() {
        return this.gui.getSSLInit();
    }

    public JPanel getSecurityInfoPanel() {
        return this.securityInfoPanel;
    }

    public double getTransferPercentage() {
        if (this.transferSizeTotal <= 0L) {
            return 0.0;
        }
        try {
            return (double)this.transferSizeCompleted / (double)this.transferSizeTotal;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public long getTransferSizeCompleted() {
        return this.transferSizeCompleted;
    }

    public long getTransferSizeTotal() {
        return this.transferSizeTotal;
    }

    public void initFtpKeyStore() throws Exception {
        this.ftpKeyStore = new FtpKeyStore(String.valueOf(this.gui.getFtpHomeDirectory()) + File.separator + "cert.key", Constants.KEYSTORE_PASSWORD);
    }

    public void setCertificateCheck(boolean bl2) {
        this.checkCert = bl2;
    }

    public void setCommand(String string) {
        this.gui.getSessionLoggingFrame().getSessionTA().append("> " + string + "\n");
    }

    public void setHostInfo(HostInfo hostInfo) {
        this.hostInfo = hostInfo;
    }

    public void setResponse(String string) {
        this.gui.getSessionLoggingFrame().getSessionTA().append(string);
    }

    public void startConnection(String string) {
        this.securityInfoPanel = new FtpSecurityPanel(string);
    }

    public void startDirEntry() {
        this.gui.getServerPanel().clearSelections();
        this.gui.getServerPanel().removeAllRows();
        this.fileList = new Vector();
    }

    public void startFileTransfer(long l2) {
        this.transferSizeCompleted = 0L;
        this.transferSizeTotal = l2;
    }

    public void startSSLConnection(X509Certificate x509Certificate) throws CertificateException {
        this.certificate = x509Certificate;
        this.securityInfoPanel = new SSLSecurityPanel(this.certificate);
    }

    public boolean trustNewCertificate(X509Certificate x509Certificate) {
        this.certificate = x509Certificate;
        this.securityInfoPanel = new SSLSecurityPanel(x509Certificate);
        return NewCertificateDialog.processCertificate(this.gui);
    }

    public void updateFileTransfer(int n2) {
        this.transferSizeCompleted += (long)n2;
    }
}

