/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.data;

import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.LString;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class CertificateInfo {
    X509Certificate cert;
    Hashtable subject;
    Hashtable issuer;

    public CertificateInfo(X509Certificate x509Certificate) {
        this.cert = x509Certificate;
        this.subject = this.parsePrincipalString(this.cert.getSubjectDN().toString());
        this.issuer = this.parsePrincipalString(this.cert.getIssuerDN().toString());
    }

    public String getCN() {
        return (String)this.subject.get("CN");
    }

    public String getCountry() {
        return (String)this.subject.get("C");
    }

    public String getEmail() {
        return (String)this.subject.get("EMail");
    }

    public Date getEndDate() {
        return this.cert.getNotAfter();
    }

    public String getFingerprint() {
        byte[] byArray;
        Object object;
        try {
            object = MessageDigest.getInstance("MD5");
            byArray = ((MessageDigest)object).digest(this.cert.getEncoded());
        }
        catch (Exception exception) {
            debug.println(exception.getMessage());
            return "<" + new LString("ssl_panel.cert_fingerpint.error.label", "error occurred while calculating fingerprint").getString() + ">";
        }
        object = new char[byArray.length * 3 - 1];
        int n2 = 0;
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        object[n2++] = cArray[(byArray[0] & 0xFF) >> 4];
        object[n2++] = cArray[byArray[0] & 0xF];
        int n3 = 1;
        while (n3 < byArray.length) {
            object[n2++] = 58;
            object[n2++] = cArray[(byArray[n3] & 0xFF) >> 4];
            object[n2++] = cArray[byArray[n3] & 0xF];
            ++n3;
        }
        return new String((char[])object);
    }

    public String getIssuerCN() {
        return (String)this.issuer.get("CN");
    }

    public String getIssuerCountry() {
        return (String)this.issuer.get("C");
    }

    public String getIssuerEmail() {
        return (String)this.issuer.get("EMail");
    }

    public String getIssuerLocality() {
        return (String)this.issuer.get("L");
    }

    public String getIssuerOU() {
        return (String)this.issuer.get("OU");
    }

    public String getIssuerOrg() {
        return (String)this.issuer.get("O");
    }

    public String getIssuerState() {
        return (String)this.issuer.get("ST");
    }

    public String getLocality() {
        return (String)this.subject.get("L");
    }

    public String getOU() {
        return (String)this.subject.get("OU");
    }

    public String getOrg() {
        return (String)this.subject.get("O");
    }

    public String getSerialNumber() {
        return this.cert.getSerialNumber().toString();
    }

    public Date getStartDate() {
        return this.cert.getNotBefore();
    }

    public String getState() {
        return (String)this.subject.get("ST");
    }

    private Hashtable parsePrincipalString(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n2 = string2.indexOf(61);
            if (n2 <= 0) continue;
            hashtable.put(string2.substring(0, n2), string2.substring(n2 + 1));
        }
        return hashtable;
    }
}

