/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.data;

import edu.sdsc.secureftp.data.Bookmark;
import edu.sdsc.secureftp.data.XMLParser;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BookmarkVector
extends Vector {
    String file;

    public BookmarkVector(String string) {
        this.file = string;
    }

    public void addBookmark(Bookmark bookmark) {
        this.addElement(bookmark);
    }

    private Bookmark parseBookmark(Hashtable hashtable) {
        try {
            String string = (String)hashtable.get("profile");
            if (string == null) {
                return null;
            }
            String string2 = (String)hashtable.get("hostname");
            String string3 = (String)hashtable.get("port");
            String string4 = (String)hashtable.get("username");
            String string5 = (String)hashtable.get("password");
            int n2 = Integer.parseInt((String)hashtable.get("security"));
            boolean bl2 = Boolean.valueOf((String)hashtable.get("pasv"));
            boolean bl3 = Boolean.valueOf((String)hashtable.get("anon"));
            boolean bl4 = Boolean.valueOf((String)hashtable.get("proxy"));
            boolean bl5 = Boolean.valueOf((String)hashtable.get("ssldata"));
            String string6 = (String)hashtable.get("localdir");
            String string7 = (String)hashtable.get("remotedir");
            return new Bookmark(string, string2, string3, string4, string5, n2, bl2, bl3, bl4, bl5, string6, string7);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void readFromDisk() throws IOException, SecurityException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));
            Hashtable hashtable = XMLParser.parse(bufferedReader, "bookmark");
            while (!hashtable.isEmpty()) {
                Bookmark bookmark = this.parseBookmark(hashtable);
                if (bookmark != null) {
                    this.addElement(bookmark);
                }
                hashtable = XMLParser.parse(bufferedReader, "bookmark");
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public void writeToDisk() throws IOException {
        PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(this.file), true);
        printWriter.println("<?xml version=\"1.0\">\n\n<!-- This is a generated file.  Do not edit! -->\n\n<!DOCTYPE booklist SYSTEM \"booklist.dtd\">\n");
        printWriter.println("<booklist>");
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Bookmark bookmark = (Bookmark)enumeration.nextElement();
            printWriter.println("  <bookmark>");
            if (bookmark.getName() != null) {
                printWriter.println("    <profile>" + bookmark.getName() + "</profile>");
            }
            if (bookmark.getHostname() != null) {
                printWriter.println("    <hostname>" + bookmark.getHostname() + "</hostname>");
            }
            if (bookmark.getPort() != null) {
                printWriter.println("    <port>" + bookmark.getPort() + "</port>");
            }
            if (bookmark.getUsername() != null) {
                printWriter.println("    <username>" + bookmark.getUsername() + "</username>");
            }
            if (bookmark.getPassword() != null) {
                printWriter.println("    <password>" + bookmark.getPassword() + "</password>");
            }
            printWriter.println("    <security>" + bookmark.getSecurity() + "</security>");
            printWriter.println("    <pasv>" + bookmark.getPasv() + "</pasv>");
            printWriter.println("    <anon>" + bookmark.getAnon() + "</anon>");
            printWriter.println("    <proxy>" + bookmark.getProxy() + "</proxy>");
            printWriter.println("    <ssldata>" + bookmark.getSSLData() + "</ssldata>");
            if (bookmark.getLocalDir() != null) {
                printWriter.println("    <localdir>" + bookmark.getLocalDir() + "</localdir>");
            }
            if (bookmark.getRemoteDir() != null) {
                printWriter.println("    <remotedir>" + bookmark.getRemoteDir() + "</remotedir>");
            }
            printWriter.println("  </bookmark>");
        }
        printWriter.println("</booklist>\n");
        printWriter.close();
    }
}

