/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.BtreeDict;
import com.sun.java.help.search.BtreeDictParameters;
import com.sun.java.help.search.ByteArrayDecompressor;
import com.sun.java.help.search.ConceptList;
import com.sun.java.help.search.IntegerArray;
import com.sun.java.help.search.NonnegativeIntegerGenerator;
import com.sun.java.help.search.QueryHit;
import com.sun.java.help.search.RAFFile;
import com.sun.java.help.search.RAFFileFactory;
import com.sun.java.help.search.Schema;
import com.sun.java.help.search.StreamDecompressor;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.Vector;
import javax.help.search.SearchItem;

class SearchEnvironment {
    private IntegerArray concepts;
    private IntegerArray offsets;
    private byte[] allLists;
    private IntegerArray concepts3;
    private IntegerArray offsets3;
    private byte[] allChildren;
    private IntegerArray documents;
    private IntegerArray offsets2;
    private IntegerArray titles;
    private RAFFile positionsFile = null;
    private byte[] positions;
    private ByteArrayDecompressor compr;
    private BtreeDict tmap;
    private URL base;
    private String indexDir;
    static boolean on1dot3 = false;
    private static boolean debugFlag;
    static /* synthetic */ Class class$java$awt$datatransfer$DataFlavor;

    static {
        try {
            Method method = (class$java$awt$datatransfer$DataFlavor != null ? class$java$awt$datatransfer$DataFlavor : (class$java$awt$datatransfer$DataFlavor = SearchEnvironment.class$("java.awt.datatransfer.DataFlavor"))).getMethod("getTextPlainUnicodeFlavor", null);
            on1dot3 = method != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            on1dot3 = false;
        }
        debugFlag = false;
    }

    public SearchEnvironment(String string, URL uRL) throws Exception {
        this.base = uRL;
        this.indexDir = string;
        this.readFromDB();
        this.compr = new ByteArrayDecompressor(null, 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() throws IOException {
        this.positionsFile.close();
    }

    private static void debug(String string) {
        if (debugFlag) {
            System.out.println("SearchEnvironment: " + string);
        }
    }

    public String fetch(int n2) throws Exception {
        return this.tmap.fetch(n2);
    }

    public int fetch(String string) throws Exception {
        return this.tmap.fetch(string);
    }

    public NonnegativeIntegerGenerator getChildIterator(int n2) {
        int n3 = this.concepts3.indexOf(n2);
        if (n3 >= 0) {
            return new ConceptList(this.allChildren, this.offsets3.at(n3));
        }
        return null;
    }

    public void getChildren(int n2, IntegerArray integerArray) throws Exception {
        int n3 = this.concepts3.indexOf(n2);
        if (n3 >= 0) {
            int n4 = this.offsets3.at(n3);
            this.compr.initReading(this.allChildren, n4 + 1);
            this.compr.ascDecode(this.allChildren[n4], integerArray);
        }
    }

    public int getConceptLength(int n2) throws Exception {
        return this.tmap.fetch(n2).length();
    }

    public int getDocumentIndex(int n2) {
        return this.offsets2.at(n2);
    }

    public NonnegativeIntegerGenerator getDocumentIterator(int n2) {
        int n3 = this.concepts.indexOf(n2);
        if (n3 >= 0) {
            return new ConceptList(this.allLists, this.offsets.at(n3));
        }
        return null;
    }

    public byte[] getPositions(int n2) throws IOException {
        int n3 = this.offsets2.at(n2);
        int n4 = n2 + 1 == this.offsets2.cardinality() ? (int)this.positionsFile.length() : this.offsets2.at(n2 + 1);
        this.positions = new byte[n4 - n3];
        this.positionsFile.seek(n3);
        this.positionsFile.read(this.positions, 0, n4 - n3);
        return this.positions;
    }

    private URL getURL(String string) throws MalformedURLException {
        URL uRL = this.base;
        String string2 = this.indexDir;
        URL uRL2 = null;
        if (uRL == null) {
            File file = new File(string2);
            if (file.exists()) {
                if (File.separatorChar != '/') {
                    string2 = string2.replace(File.separatorChar, '/');
                }
                if (string2.lastIndexOf(47) != string2.length() - 1) {
                    string2 = string2.concat("/");
                }
                SearchEnvironment.debug("file:" + string2);
                uRL2 = new URL("file", "", string2);
            } else {
                uRL2 = new URL(string2);
            }
        }
        URL uRL3 = uRL != null ? new URL(uRL, String.valueOf(string2) + "/" + string) : new URL(uRL2, string);
        return uRL3;
    }

    public String hitToString(QueryHit queryHit) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(queryHit.getScore());
        stringBuffer.append(" ");
        stringBuffer.append(this.fetch(this.documents.at(queryHit.getDocument())));
        stringBuffer.append(" [");
        int n2 = queryHit.getBegin();
        int n3 = queryHit.getEnd();
        if (on1dot3) {
            n2 -= 2;
            n3 -= 2;
        }
        stringBuffer.append(n2);
        stringBuffer.append(", ");
        stringBuffer.append(n3);
        stringBuffer.append("], {");
        int[] nArray = queryHit.getArray();
        int n4 = 0;
        while (n4 < nArray.length) {
            if (nArray[n4] > 0) {
                stringBuffer.append(this.fetch(nArray[n4]));
            } else {
                stringBuffer.append("--");
            }
            if (n4 < nArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n4;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public SearchItem makeItem(QueryHit queryHit) throws Exception {
        Vector<String> vector = new Vector<String>();
        int[] nArray = queryHit.getArray();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] > 0) {
                vector.addElement(this.fetch(nArray[n2]));
            }
            ++n2;
        }
        int n3 = queryHit.getBegin();
        int n4 = queryHit.getEnd();
        if (on1dot3) {
            n3 -= 2;
            n4 -= 2;
        }
        return new SearchItem(this.base, this.fetch(this.titles.at(queryHit.getDocument())), Locale.getDefault().toString(), this.fetch(this.documents.at(queryHit.getDocument())), queryHit.getScore(), n3, n4, vector);
    }

    public boolean occursInText(int n2) {
        return this.concepts.indexOf(n2) >= 0;
    }

    private void readChildrenData() throws Exception {
        try {
            URL uRL = this.getURL("CHILDREN.TAB");
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            if (inputStream == null) {
                this.concepts3 = new IntegerArray(1);
                return;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            int n2 = bufferedInputStream.read();
            this.concepts3 = new IntegerArray(4096);
            StreamDecompressor streamDecompressor = new StreamDecompressor(bufferedInputStream);
            streamDecompressor.ascDecode(n2, this.concepts3);
            int n3 = bufferedInputStream.read();
            this.offsets3 = new IntegerArray(this.concepts3.cardinality() + 1);
            this.offsets3.add(0);
            StreamDecompressor streamDecompressor2 = new StreamDecompressor(bufferedInputStream);
            streamDecompressor2.ascDecode(n3, this.offsets3);
            bufferedInputStream.close();
            uRL = this.getURL("CHILDREN");
            uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            if (inputStream == null) {
                this.concepts3 = new IntegerArray(1);
                return;
            }
            bufferedInputStream = new BufferedInputStream(inputStream);
            int n4 = uRLConnection.getContentLength();
            this.allChildren = new byte[n4];
            bufferedInputStream.read(this.allChildren);
            bufferedInputStream.close();
        }
        catch (MalformedURLException malformedURLException) {
            this.concepts3 = new IntegerArray(1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.concepts3 = new IntegerArray(1);
        }
        catch (IOException iOException) {
            this.concepts3 = new IntegerArray(1);
        }
    }

    private void readFromDB() throws Exception {
        BufferedInputStream bufferedInputStream = null;
        Schema schema = new Schema(this.base, this.indexDir, false);
        BtreeDictParameters btreeDictParameters = new BtreeDictParameters(schema, "TMAP");
        btreeDictParameters.readState();
        this.tmap = new BtreeDict(btreeDictParameters);
        this.readChildrenData();
        URL uRL = this.getURL("DOCS.TAB");
        URLConnection uRLConnection = uRL.openConnection();
        bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        int n2 = bufferedInputStream.read();
        this.concepts = new IntegerArray(4096);
        StreamDecompressor streamDecompressor = new StreamDecompressor(bufferedInputStream);
        streamDecompressor.ascDecode(n2, this.concepts);
        int n3 = bufferedInputStream.read();
        this.offsets = new IntegerArray(this.concepts.cardinality() + 1);
        this.offsets.add(0);
        StreamDecompressor streamDecompressor2 = new StreamDecompressor(bufferedInputStream);
        streamDecompressor2.ascDecode(n3, this.offsets);
        bufferedInputStream.close();
        uRL = this.getURL("DOCS");
        uRLConnection = uRL.openConnection();
        bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[512];
        int n4 = 0;
        while ((n4 = bufferedInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n4);
        }
        this.allLists = byteArrayOutputStream.toByteArray();
        bufferedInputStream.close();
        uRL = this.getURL("OFFSETS");
        uRLConnection = uRL.openConnection();
        bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        n2 = bufferedInputStream.read();
        this.documents = new IntegerArray(4096);
        streamDecompressor = new StreamDecompressor(bufferedInputStream);
        streamDecompressor.ascDecode(n2, this.documents);
        n3 = bufferedInputStream.read();
        this.offsets2 = new IntegerArray(this.documents.cardinality() + 1);
        streamDecompressor2 = new StreamDecompressor(bufferedInputStream);
        streamDecompressor2.ascDecode(n3, this.offsets2);
        int n5 = bufferedInputStream.read();
        this.titles = new IntegerArray(this.documents.cardinality());
        StreamDecompressor streamDecompressor3 = new StreamDecompressor(bufferedInputStream);
        streamDecompressor3.decode(n5, this.titles);
        bufferedInputStream.close();
        RAFFileFactory rAFFileFactory = RAFFileFactory.create();
        uRL = this.getURL("POSITIONS");
        this.positionsFile = rAFFileFactory.get(uRL, false);
    }
}

