/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.RAFFile;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class MemoryRAFFile
extends RAFFile {
    private URL url;
    private byte[] data;
    private int size;
    private int filePointer;
    private static boolean debugFlag = false;

    public MemoryRAFFile(URLConnection uRLConnection) throws IOException {
        this.url = uRLConnection.getURL();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[512];
        int n2 = 0;
        while ((n2 = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        this.data = byteArrayOutputStream.toByteArray();
        this.size = byteArrayOutputStream.size();
        this.filePointer = 0;
    }

    public void close() throws IOException {
        this.filePointer = 0;
        this.data = null;
        this.size = 0;
    }

    private static void debug(String string) {
        if (debugFlag) {
            System.out.println("MemoryRAFFile: " + string);
        }
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public long length() {
        return this.size;
    }

    public int read() throws IOException {
        if (this.filePointer >= this.size) {
            return -1;
        }
        ++this.filePointer;
        return this.data[this.filePointer - 1] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.readBytes(byArray, n2, n3);
    }

    private int readBytes(byte[] byArray, int n2, int n3) throws IOException {
        MemoryRAFFile.debug("readBytes");
        if (this.filePointer + n2 + n3 > this.size) {
            throw new IOException();
        }
        this.filePointer += n2;
        System.arraycopy(this.data, this.filePointer, byArray, 0, n3);
        this.filePointer += n3;
        return n3;
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    private void readFully(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = 0;
        do {
            if ((n4 = this.read(byArray, n2 + n5, n3 - n5)) >= 0) continue;
            throw new EOFException();
        } while ((n5 += n4) < n3);
    }

    public int readInt() throws IOException {
        MemoryRAFFile.debug("readInt");
        int n2 = this.read();
        int n3 = this.read();
        int n4 = this.read();
        int n5 = this.read();
        if ((n2 | n3 | n4 | n5) < 0) {
            throw new EOFException();
        }
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    public void seek(long l2) throws IOException {
        if (l2 > (long)this.size) {
            throw new IOException();
        }
        this.filePointer = (int)l2;
    }

    public void write(byte[] byArray) throws IOException {
        throw new IOException("Unsupported Operation");
    }

    public void writeInt(int n2) throws IOException {
        throw new IOException("Unsupported Operation");
    }
}

