/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.HitStoreNode;
import com.sun.java.help.search.QueryHit;
import java.util.Vector;

class HitStore {
    private static final int ArraySize = 128;
    private static final int DefaultLimit = 300;
    private HitStoreNode _root = new HitStoreNode(128);
    private int _limit;
    private double _standard;
    private Vector _leaves = null;
    private HitStoreNode _current = null;

    public HitStore(double d10) {
        this(d10, 300);
    }

    public HitStore(double d10, int n2) {
        this._limit = n2;
        this._standard = d10;
    }

    private void adapt() {
        if (this._root.getCount() > this._limit && !this._root.isLeaf()) {
            HitStoreNode hitStoreNode = this._root;
            while (!hitStoreNode.getRChild().isLeaf()) {
                hitStoreNode = hitStoreNode.getRChild();
            }
            this._standard = hitStoreNode.getDivider();
            if (hitStoreNode == this._root) {
                this._root = hitStoreNode.getLChild();
            } else {
                int n2 = hitStoreNode.getRChild().getCount();
                HitStoreNode hitStoreNode2 = this._root;
                while (hitStoreNode2.getRChild() != hitStoreNode) {
                    hitStoreNode2.decrementCount(n2);
                    hitStoreNode2 = hitStoreNode2.getRChild();
                }
                hitStoreNode2.setRChild(hitStoreNode.getLChild());
            }
            hitStoreNode.setLChild(null);
        }
    }

    public void addQueryHit(QueryHit queryHit) {
        if (this._root.add(queryHit)) {
            this.adapt();
        }
    }

    public QueryHit firstBestQueryHit() {
        this._leaves = new Vector();
        this._root.gatherLeaves(this._leaves);
        this._current = this.getNextNode();
        return this._current.getNextHit();
    }

    double getCurrentStandard() {
        return this._standard;
    }

    private HitStoreNode getNextNode() {
        if (this._leaves.size() > 0) {
            HitStoreNode hitStoreNode = (HitStoreNode)this._leaves.firstElement();
            this._leaves.removeElementAt(0);
            hitStoreNode.sort();
            return hitStoreNode;
        }
        return null;
    }

    public QueryHit nextBestQueryHit() {
        QueryHit queryHit = this._current.getNextHit();
        if (queryHit != null) {
            return queryHit;
        }
        this._current = this.getNextNode();
        if (this._current != null) {
            return this._current.getNextHit();
        }
        return null;
    }
}

