/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Block;
import com.sun.java.help.search.BlockFactory;
import com.sun.java.help.search.BlockManager;
import com.sun.java.help.search.BlockProcessor;
import com.sun.java.help.search.BtreeDictParameters;
import com.sun.java.help.search.Schema;

public class BtreeDict {
    protected static final int ENTHEADERLEN = 6;
    protected static final int BLOCKSIZE = 2048;
    protected static final int DATALEN = 2040;
    protected static final int MaxKeyLength = 255;
    protected static final int lastPtrIndex = 508;
    protected BlockManager blockManager;
    protected int root;
    protected int[] blocks;
    private boolean debug = false;

    protected BtreeDict() {
    }

    public BtreeDict(BtreeDictParameters btreeDictParameters) throws Exception {
        this.init(btreeDictParameters, false, new BlockFactory(){

            public Block makeBlock() {
                return new DictBlock();
            }
        });
        this.blocks = new int[btreeDictParameters.getFreeID()];
        this.setBlocks(this.blocks);
    }

    protected DictBlock accessBlock(int n2) throws Exception {
        return (DictBlock)this.blockManager.accessBlock(n2);
    }

    protected DictBlock child(DictBlock dictBlock, int n2) throws Exception {
        return this.accessBlock(dictBlock.getChildIdx(n2));
    }

    public void close() throws Exception {
        this.blockManager.close();
    }

    private void debug(String string) {
        if (this.debug) {
            System.err.println("BtreeDict: " + string);
        }
    }

    public String fetch(int n2) throws Exception {
        return this.findID(this.blocks[n2], n2);
    }

    public int fetch(String string) throws Exception {
        int n2 = string.length();
        byte[] byArray = new byte[n2 + 1];
        System.arraycopy(string.getBytes(), 0, byArray, 0, n2);
        byArray[n2] = 0;
        return this.find(this.accessBlock(this.root), byArray);
    }

    private int find(DictBlock dictBlock, byte[] byArray) throws Exception {
        int n2 = byArray.length - 1;
        int n3 = dictBlock.firstEntry();
        int n4 = dictBlock.free();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n3 != n4) {
            if (n6 == n5) {
                int n8 = dictBlock.entryKeyLength(n3);
                int n9 = dictBlock.entryKey(n3);
                int n10 = 0;
                while (n10 < n8 && byArray[n5] == dictBlock.data[n9 + n10]) {
                    ++n5;
                    ++n10;
                }
                if (n10 == n8) {
                    if (n5 == n2) {
                        return dictBlock.entryID(n3);
                    }
                } else if ((byArray[n5] & 0xFF) < (dictBlock.data[n9 + n10] & 0xFF)) {
                    return this.find(dictBlock, byArray, n7);
                }
            } else if (n6 < n5) {
                return this.find(dictBlock, byArray, n3 == n4 ? dictBlock.numberOfEntries() : n7);
            }
            do {
                n3 = dictBlock.nextEntry(n3);
                ++n7;
            } while (dictBlock.entryCompression(n3) > n5);
            n6 = dictBlock.entryCompression(n3);
        }
        return this.find(dictBlock, byArray, dictBlock.numberOfEntries());
    }

    private int find(DictBlock dictBlock, byte[] byArray, int n2) throws Exception {
        return dictBlock.isLeaf ? 0 : this.find(this.child(dictBlock, n2), byArray);
    }

    private String findID(int n2, int n3) throws Exception {
        return this.accessBlock(n2).findID(n3);
    }

    protected void init(BtreeDictParameters btreeDictParameters, boolean bl2, BlockFactory blockFactory) throws Exception {
        this.blockManager = new BlockManager(btreeDictParameters, bl2, blockFactory);
        this.root = btreeDictParameters.getRootPosition();
    }

    protected void lock(Block block) {
        this.blockManager.lockBlock(block.number);
    }

    public static void main(String[] stringArray) {
        try {
            Schema schema = new Schema(null, stringArray[0], false);
            BtreeDictParameters btreeDictParameters = new BtreeDictParameters(schema, "TMAP");
            BtreeDict btreeDict = new BtreeDict(btreeDictParameters);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    private void setBlocks(final int[] nArray) throws Exception {
        long l2 = System.currentTimeMillis();
        this.blockManager.mapBlocks(new BlockProcessor(){

            public void process(Block block) {
                ((DictBlock)block).setBlockNumbers(nArray);
            }
        });
        this.debug(String.valueOf(System.currentTimeMillis() - l2) + " msec; TMAP");
    }

    protected void unlock(Block block) {
        this.blockManager.unlockBlock(block.number);
    }

    protected class DictBlock
    extends Block {
        public DictBlock() {
            super(2048);
        }

        public int entryCompression(int n2) {
            return this.data[n2 + 1] & 0xFF;
        }

        public int entryID(int n2) {
            return this.integerAt(n2 + 2);
        }

        public int entryKey(int n2) {
            return n2 + 6;
        }

        public int entryKeyLength(int n2) {
            return this.data[n2] & 0xFF;
        }

        public int entryLength(int n2) {
            return 6 + this.entryKeyLength(n2);
        }

        public String findID(int n2) throws Exception {
            byte[] byArray = new byte[255];
            int n3 = this.free();
            int n4 = this.firstEntry();
            while (n4 < n3) {
                if (this.entryID(n4) == n2) {
                    return this.restoreKey(n4, byArray);
                }
                this.restoreKeyInBuffer(n4, byArray);
                n4 = this.nextEntry(n4);
            }
            throw new Exception("ID not found in block");
        }

        public int firstEntry() {
            return 4;
        }

        public int free() {
            return this.free + this.firstEntry();
        }

        public int getChildIdx(int n2) {
            return this.nthPointer(508 - n2);
        }

        public int nextEntry(int n2) {
            return n2 + this.entryLength(n2);
        }

        public int nthPointer(int n2) {
            return this.integerAt(4 * (n2 + 1));
        }

        public int numberOfEntries() {
            return this.integerAt(0);
        }

        public String restoreKey(int n2, byte[] byArray) {
            int n3 = this.entryKeyLength(n2);
            int n4 = this.entryCompression(n2);
            int n5 = this.entryKey(n2);
            while (n3-- > 0) {
                byArray[n4++] = this.data[n5++];
            }
            return new String(byArray, 0, n4);
        }

        public void restoreKeyInBuffer(int n2, byte[] byArray) {
            int n3 = this.entryKeyLength(n2);
            int n4 = this.entryCompression(n2);
            int n5 = this.entryKey(n2);
            while (n3-- > 0) {
                byArray[n4++] = this.data[n5++];
            }
        }

        protected void setBlockNumbers(int[] nArray) {
            int n2 = this.firstEntry();
            while (n2 < this.free) {
                nArray[this.entryID((int)n2)] = this.number;
                n2 = this.nextEntry(n2);
            }
        }
    }
}

