/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.impl;

import com.sun.java.help.impl.MyBufferedReader;
import com.sun.java.help.impl.ScanBuffer;
import com.sun.java.help.impl.TagProperties;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public abstract class DocumentParser {
    static final char EOF = '\uffff';
    protected Reader source;
    int readOffset;
    ScanBuffer buffer;
    ScanBuffer escapeBuffer;
    ScanBuffer documentSource;
    boolean shouldCacheSource;
    Hashtable entities;
    int defaultCharBufferSize = 8192;
    char[] cb = new char[this.defaultCharBufferSize];
    int mySize = 0;
    int myCount = 0;

    public DocumentParser(InputStream inputStream) {
        this.source = new MyBufferedReader(new InputStreamReader(inputStream));
        this.init();
    }

    public DocumentParser(Reader reader) {
        this.source = reader instanceof MyBufferedReader ? reader : new MyBufferedReader(reader);
        this.init();
    }

    protected void callFlush(char[] cArray, int n2, int n3) {
        this.flush(cArray, n2, n3);
    }

    protected abstract void comment(String var1);

    protected void commentEOFError(int n2) {
        this.eofError();
    }

    protected abstract void doctype(String var1, String var2, String var3);

    protected abstract String documentAttribute(String var1);

    protected void eofError() {
        this.error("Unexpected end of file");
        this.generateError(0);
    }

    void error(String string) {
        System.err.println("DocumentParser Error: " + string);
    }

    protected abstract void errorString(String var1);

    protected void findCloseAngleForComment(char c10) throws IOException {
        this.buffer.add(c10);
        while ((c10 = this.readChar()) != '>') {
            this.buffer.add(c10);
        }
        this.buffer.add(c10);
        this.comment(this.buffer.extract(0));
        this.buffer.clear();
    }

    protected abstract void flush(char[] var1, int var2, int var3);

    protected void generateError(int n2) {
        String string = this.buffer.extract(n2);
        this.buffer.reset(n2);
        this.buffer.flush(this);
        this.errorString(string);
    }

    public String getDocumentSource() {
        if (!this.shouldCacheSource) {
            return null;
        }
        int n2 = this.documentSource.length() == 0 ? 0 : this.documentSource.length() - 1;
        return String.valueOf(new String(this.documentSource.buf, 0, n2)) + "\n";
    }

    protected char handleCommentOrDoctype(char c10) throws IOException {
        this.buffer.add(c10);
        int n2 = this.buffer.length();
        c10 = this.scanIdentifier(c10);
        String string = this.buffer.extract(n2);
        if (!string.equals("DOCTYPE")) {
            this.findCloseAngleForComment(c10);
            return this.readChar();
        }
        c10 = this.skipWhite(c10);
        n2 = this.buffer.length();
        c10 = this.scanIdentifier(c10);
        String string2 = this.buffer.extract(n2);
        if ((c10 = this.skipWhite(c10)) == '>') {
            this.buffer.clear();
            return this.readChar();
        }
        n2 = this.buffer.length();
        c10 = this.scanIdentifier(c10);
        string = this.buffer.extract(n2);
        String string3 = null;
        String string4 = null;
        if (string.equals("SYSTEM")) {
            c10 = this.skipWhite(c10);
            n2 = this.buffer.length();
            c10 = this.scanQuotedString(c10);
            string4 = this.buffer.extract(n2);
            this.doctype(string2, null, string4);
            if (c10 != '>') {
                this.findCloseAngleForComment(c10);
            }
            this.buffer.clear();
            return this.readChar();
        }
        if (string.equals("PUBLIC")) {
            c10 = this.skipWhite(c10);
            n2 = this.buffer.length();
            c10 = this.scanQuotedString(c10);
            string3 = this.buffer.extract(n2);
            c10 = this.skipWhite(c10);
            n2 = this.buffer.length();
            c10 = this.scanQuotedString(c10);
            string4 = this.buffer.extract(n2);
            this.doctype(string2, string3, string4);
            if (c10 != '>') {
                this.findCloseAngleForComment(c10);
            }
            this.buffer.clear();
            return this.readChar();
        }
        if (c10 != '>') {
            this.findCloseAngleForComment(c10);
        }
        this.findCloseAngleForComment(c10);
        this.doctype(string2, null, null);
        this.buffer.clear();
        return this.readChar();
    }

    private void init() {
        this.buffer = new ScanBuffer(8192, 4);
        this.escapeBuffer = new ScanBuffer(8192, 4);
        this.documentSource = new ScanBuffer(8192, 4);
        this.readOffset = 0;
    }

    protected void initEntities() {
        this.entities = new Hashtable();
        this.entities.put("quot", new Character('\"'));
        this.entities.put("amp", new Character('&'));
        this.entities.put("gt", new Character('>'));
        this.entities.put("lt", new Character('<'));
        this.entities.put("nbsp", new Character('\u00a0'));
        this.entities.put("copy", new Character('\u00a9'));
        this.entities.put("Agrave", new Character('\u00c0'));
        this.entities.put("Aacute", new Character('\u00c1'));
        this.entities.put("Acirc", new Character('\u00c2'));
        this.entities.put("Atilde", new Character('\u00c3'));
        this.entities.put("Auml", new Character('\u00c4'));
        this.entities.put("Aring", new Character('\u00c5'));
        this.entities.put("AElig", new Character('\u00c6'));
        this.entities.put("Ccedil", new Character('\u00c7'));
        this.entities.put("Egrave", new Character('\u00c8'));
        this.entities.put("Eacute", new Character('\u00c9'));
        this.entities.put("Ecirc", new Character('\u00ca'));
        this.entities.put("Euml", new Character('\u00cb'));
        this.entities.put("Igrave", new Character('\u00cc'));
        this.entities.put("Iacute", new Character('\u00cd'));
        this.entities.put("Icirc", new Character('\u00ce'));
        this.entities.put("Iuml", new Character('\u00cf'));
        this.entities.put("Ntilde", new Character('\u00d1'));
        this.entities.put("Ograve", new Character('\u00d2'));
        this.entities.put("Oacute", new Character('\u00d3'));
        this.entities.put("Ocirc", new Character('\u00d4'));
        this.entities.put("Otilde", new Character('\u00d5'));
        this.entities.put("Ouml", new Character('\u00d6'));
        this.entities.put("Oslash", new Character('\u00d8'));
        this.entities.put("Ugrave", new Character('\u00d9'));
        this.entities.put("Uacute", new Character('\u00da'));
        this.entities.put("Ucirc", new Character('\u00db'));
        this.entities.put("Uuml", new Character('\u00dc'));
        this.entities.put("Yacute", new Character('\u00dd'));
        this.entities.put("THORN", new Character('\u00de'));
        this.entities.put("szlig", new Character('\u00df'));
        this.entities.put("agrave", new Character('\u00e0'));
        this.entities.put("aacute", new Character('\u00e1'));
        this.entities.put("acirc", new Character('\u00e2'));
        this.entities.put("atilde", new Character('\u00e3'));
        this.entities.put("auml", new Character('\u00e4'));
        this.entities.put("aring", new Character('\u00e5'));
        this.entities.put("aelig", new Character('\u00e6'));
        this.entities.put("ccedil", new Character('\u00e7'));
        this.entities.put("egrave", new Character('\u00e8'));
        this.entities.put("eacute", new Character('\u00e9'));
        this.entities.put("ecirc", new Character('\u00ea'));
        this.entities.put("euml", new Character('\u00eb'));
        this.entities.put("igrave", new Character('\u00ec'));
        this.entities.put("iacute", new Character('\u00ed'));
        this.entities.put("icirc", new Character('\u00ee'));
        this.entities.put("iuml", new Character('\u00ef'));
        this.entities.put("eth", new Character('\u00f0'));
        this.entities.put("ntilde", new Character('\u00f1'));
        this.entities.put("ograve", new Character('\u00f2'));
        this.entities.put("oacute", new Character('\u00f3'));
        this.entities.put("ocirc", new Character('\u00f4'));
        this.entities.put("otilde", new Character('\u00f5'));
        this.entities.put("ouml", new Character('\u00f6'));
        this.entities.put("oslash", new Character('\u00f8'));
        this.entities.put("ugrave", new Character('\u00f9'));
        this.entities.put("uacute", new Character('\u00fa'));
        this.entities.put("ucirc", new Character('\u00fb'));
        this.entities.put("uuml", new Character('\u00fc'));
        this.entities.put("yacute", new Character('\u00fd'));
        this.entities.put("thorn", new Character('\u00fe'));
        this.entities.put("yuml", new Character('\u00ff'));
    }

    public void parse() throws IOException {
        int n2 = 65535;
        this.buffer.clear();
        if (this.source != null) {
            n2 = this.readChar();
        }
        while (n2 != 65535) {
            if (n2 == 38) {
                n2 = this.parseEscape();
                continue;
            }
            if (n2 == 60) {
                this.buffer.flush(this);
                n2 = this.parseTag();
                continue;
            }
            if (this.buffer.buflen >= this.buffer.buf.length) {
                char[] cArray = new char[this.buffer.buf.length * this.buffer.scale];
                System.arraycopy(this.buffer.buf, 0, cArray, 0, this.buffer.buf.length);
                this.buffer.buf = cArray;
            }
            if (n2 != 13) {
                this.buffer.buf[this.buffer.buflen++] = n2;
            }
            if (this.myCount >= this.mySize) {
                try {
                    this.mySize = this.source.read(this.cb, 0, this.defaultCharBufferSize);
                    if (this.mySize < 0) break;
                    if (this.mySize == 0) {
                        System.err.println(" DocumentParser::parse() !!!ERROR !!! source.read(...) == 0");
                        break;
                    }
                    this.myCount = 0;
                }
                catch (CharConversionException charConversionException) {
                    throw charConversionException;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            if (this.shouldCacheSource) {
                this.documentSource.add(this.cb[this.myCount]);
            }
            n2 = this.cb[this.myCount++];
        }
        this.buffer.flush(this);
    }

    protected char parseEscape() throws IOException {
        char c10;
        block17: {
            int n2;
            block18: {
                block19: {
                    block15: {
                        block16: {
                            n2 = this.buffer.length();
                            this.buffer.add('&');
                            c10 = this.readChar();
                            if (c10 == '\uffff') {
                                this.generateError(n2);
                                return c10;
                            }
                            if (c10 != '#') break block16;
                            int n3 = 0;
                            while (true) {
                                if ((c10 = this.readChar()) == '\uffff') {
                                    this.generateError(n2);
                                    return c10;
                                }
                                if (c10 == ';') {
                                    c10 = '\u0000';
                                    break;
                                }
                                if (!Character.isDigit(c10)) {
                                    if (n3 > 0) break;
                                    this.error("Expecting a digit");
                                    this.generateError(n2);
                                    return c10;
                                }
                                this.buffer.add(c10);
                                n3 = n3 * 10 + Character.digit(c10, 10);
                            }
                            this.buffer.reset(n2);
                            this.buffer.add((char)n3);
                            break block17;
                        }
                        if (!Character.isLowerCase(c10) && !Character.isUpperCase(c10)) break block18;
                        if (this.entities == null) {
                            this.initEntities();
                        }
                        this.escapeBuffer.clear();
                        this.escapeBuffer.add(c10);
                        do {
                            this.buffer.add(c10);
                            c10 = this.readChar();
                            if (c10 == '\uffff') {
                                this.generateError(n2);
                                return c10;
                            }
                            if (!Character.isLowerCase(c10) && !Character.isUpperCase(c10)) break block15;
                            this.escapeBuffer.add(c10);
                        } while (this.entities.get(this.escapeBuffer.extract(0)) == null);
                        c10 = this.readChar();
                        if (c10 == ';') {
                            c10 = '\u0000';
                        }
                        break block19;
                    }
                    if (c10 == ';') {
                        c10 = '\u0000';
                    } else {
                        this.error("Expecting a letter");
                        this.generateError(n2);
                        return c10;
                    }
                }
                String string = this.escapeBuffer.extract(0);
                this.buffer.reset(n2);
                Character c11 = (Character)this.entities.get(string);
                if (c11 != null) {
                    return c11.charValue();
                }
                String string2 = this.documentAttribute(string);
                if (string2 != null) {
                    int n4 = 0;
                    while (n4 < string2.length()) {
                        this.buffer.add(string2.charAt(n4));
                        ++n4;
                    }
                }
                break block17;
            }
            this.error("Expecting a letter o");
            this.generateError(n2);
            return c10;
        }
        if (c10 != '\u0000') {
            return c10;
        }
        return this.readChar();
    }

    /*
     * Unable to fully structure code
     */
    protected char parseTag() throws IOException {
        block54: {
            this.buffer.clear();
            var5_1 = false;
            var1_2 = '<';
            this.buffer.add('<');
            var1_2 = this.readChar();
            if (var1_2 != 33) break block54;
            var8_3 = 0;
            this.buffer.add('!');
            var1_2 = this.readChar();
            if (var1_2 != '-') {
                return this.handleCommentOrDoctype(var1_2);
            }
            this.buffer.add(var1_2);
            var1_2 = this.readChar();
            if (var1_2 != '-') {
                this.findCloseAngleForComment(var1_2);
                return this.readChar();
            }
            this.buffer.add(var1_2);
            var8_3 = this.buffer.length();
            var9_5 = 0;
            while (true) {
                if ((var1_2 = this.readChar()) == '\uffff') {
                    this.commentEOFError(var8_3);
                    break;
                }
                if (var1_2 == 45) ** GOTO lbl30
                this.buffer.add(var1_2);
                continue;
lbl-1000:
                // 1 sources

                {
                    this.buffer.add(var1_2);
                    ++var9_5;
                    var1_2 = this.readChar();
lbl30:
                    // 2 sources

                    ** while (var1_2 == 45)
                }
lbl31:
                // 1 sources

                if (var1_2 == '\uffff') {
                    this.commentEOFError(var8_3);
                    break;
                }
                this.buffer.add(var1_2);
                if (var9_5 >= 2 && var1_2 == '>') {
                    this.comment(this.buffer.extract(0));
                    this.buffer.clear();
                    return this.readChar();
                }
                var9_5 = 0;
            }
        }
        if (var1_2 == '?') {
            var8_3 = 0;
            var9_6 = new StringBuffer();
            this.buffer.add('?');
            while ((var1_2 = this.readChar()) != '\"' && var1_2 != ' ' && var1_2 != '\t' && var1_2 != '\n' && var1_2 != '>') {
                this.buffer.add(var1_2);
                var9_6.append(var1_2);
            }
            if (!var9_6.toString().equals("xml")) {
                this.buffer.clear();
                while ((var1_2 = this.readChar()) != '?' && var1_2 != '\uffff') {
                    this.buffer.add(var1_2);
                }
                if (var1_2 == '\uffff') {
                    this.eofError();
                    return this.readChar();
                }
                var1_2 = this.readChar();
                if (var1_2 != '>' && var1_2 != '\uffff') {
                    this.buffer.add('?');
                    this.buffer.add(var1_2);
                }
                if (var1_2 == '\uffff') {
                    this.eofError();
                    return this.readChar();
                }
                this.pi(var9_6.toString(), this.buffer.extract(0));
                return this.readChar();
            }
            var9_6 = null;
            var1_2 = this.readChar();
            var3_8 = null;
            while (true) {
                if ((var1_2 = this.skipWhite(var1_2)) == '\uffff') {
                    this.eofError();
                    return var1_2;
                }
                if (var1_2 == 63) break;
                var4_10 = this.buffer.length();
                var1_2 = this.scanIdentifier(var1_2);
                if (var4_10 == this.buffer.length()) {
                    this.error("Expecting an attribute");
                    this.skipToCloseAngle(var1_2);
                    return this.readChar();
                }
                var10_12 = this.buffer.extract(var4_10);
                var1_2 = this.skipWhite(var1_2);
                if (var3_8 == null) {
                    var3_8 = new TagProperties();
                }
                if (var1_2 == '=') {
                    this.buffer.add(var1_2);
                    var1_2 = this.readChar();
                    var1_2 = this.skipWhite(var1_2);
                    if (var1_2 == '?' || var1_2 == '<') {
                        var11_14 = "";
                    } else if (var1_2 == '\"') {
                        this.buffer.add(var1_2);
                        var12_15 = this.buffer.length();
                        while (true) {
                            if ((var1_2 = this.readChar()) == '\uffff') {
                                this.eofError();
                                return var1_2;
                            }
                            if (var1_2 == 34) break;
                            if (var1_2 == '&') {
                                var1_2 = this.parseEscape();
                            }
                            this.buffer.add(var1_2);
                        }
                        var11_14 = this.buffer.extract(var12_15);
                        this.buffer.add(var1_2);
                        var1_2 = this.readChar();
                    } else {
                        var12_15 = this.buffer.length();
                        this.buffer.add(var1_2);
                        while (true) {
                            if ((var1_2 = this.readChar()) == '\uffff') {
                                this.eofError();
                                return var1_2;
                            }
                            if (var1_2 == 34 || var1_2 == 32 || var1_2 == 9 || var1_2 == 10 || var1_2 == '?') break;
                            if (var1_2 == '&') {
                                var1_2 = this.parseEscape();
                            }
                            this.buffer.add(var1_2);
                        }
                        var11_14 = this.buffer.extract(var12_15);
                    }
                } else {
                    var11_14 = "true";
                }
                var3_8.put(var10_12, var11_14);
            }
            var1_2 = this.readChar();
            if (var1_2 == '\uffff') {
                this.eofError();
                return this.readChar();
            }
            var1_2 = this.skipWhite(var1_2);
            this.buffer.add(var1_2);
            if (var1_2 == '>') {
                this.setXmlEntities(var3_8);
                this.buffer.clear();
                return this.readChar();
            }
            this.error("Expecting ?>");
            this.skipToCloseAngle(var1_2);
            return this.readChar();
        }
        if ((var1_2 = this.skipWhite(var1_2)) == '\uffff') {
            this.eofError();
            return var1_2;
        }
        if (var1_2 == '/') {
            this.buffer.add(var1_2);
            var1_2 = this.skipWhite(this.readChar());
            var6_16 = true;
            var7_17 = false;
        } else {
            var6_16 = false;
            var7_17 = false;
        }
        var4_11 = this.buffer.length();
        var1_2 = this.scanIdentifier(var1_2);
        var2_18 = this.buffer.extract(var4_11);
        var3_9 = null;
        while (true) {
            if ((var1_2 = this.skipWhite(var1_2)) == '\uffff') {
                this.eofError();
                return var1_2;
            }
            if (var1_2 == 62) break;
            if (var1_2 == '/') {
                this.buffer.add(var1_2);
                var1_2 = this.readChar();
                if (var1_2 == '>') {
                    var6_16 = true;
                    var7_17 = true;
                    break;
                }
                this.error("Expecting />");
                this.skipToCloseAngle(var1_2);
                return this.readChar();
            }
            if (var1_2 == '<') {
                this.tag(var2_18, var3_9, var6_16, false);
                this.buffer.clear();
                return '<';
            }
            var4_11 = this.buffer.length();
            var1_2 = this.scanIdentifier(var1_2);
            if (var4_11 == this.buffer.length()) {
                this.error("Expecting an attribute (2)");
                this.skipToCloseAngle(var1_2);
                return this.readChar();
            }
            var8_4 = this.buffer.extract(var4_11);
            var1_2 = this.skipWhite(var1_2);
            if (var3_9 == null) {
                var3_9 = new TagProperties();
            }
            if (var1_2 == '=') {
                this.buffer.add(var1_2);
                var1_2 = this.readChar();
                var1_2 = this.skipWhite(var1_2);
                if (var1_2 == '>' || var1_2 == '<') {
                    var9_7 = "";
                } else if (var1_2 == '\"') {
                    this.buffer.add(var1_2);
                    var10_13 = this.buffer.length();
                    while (true) {
                        if ((var1_2 = this.readChar()) == '\uffff') {
                            this.eofError();
                            return var1_2;
                        }
                        if (var1_2 == 34) break;
                        if (var1_2 == '&') {
                            var1_2 = this.parseEscape();
                        }
                        this.buffer.add(var1_2);
                    }
                    var9_7 = this.buffer.extract(var10_13);
                    this.buffer.add(var1_2);
                    var1_2 = this.readChar();
                } else {
                    var10_13 = this.buffer.length();
                    this.buffer.add(var1_2);
                    while (true) {
                        if ((var1_2 = this.readChar()) == '\uffff') {
                            this.eofError();
                            return var1_2;
                        }
                        if (var1_2 == 34 || var1_2 == 32 || var1_2 == 9 || var1_2 == 10 || var1_2 == '>') break;
                        if (var1_2 == '&') {
                            var1_2 = this.parseEscape();
                        }
                        this.buffer.add(var1_2);
                    }
                    var9_7 = this.buffer.extract(var10_13);
                }
            } else {
                var9_7 = "true";
            }
            var3_9.put(var8_4, var9_7);
        }
        this.tag(var2_18, var3_9, var6_16, var7_17);
        this.buffer.clear();
        return this.readChar();
    }

    public void parseText() throws IOException {
        this.tag("PRE", null, false, false);
        this.buffer.clear();
        char c10 = this.readChar();
        while (c10 != '\uffff') {
            this.buffer.add(c10);
            c10 = this.readChar();
        }
        this.buffer.flush(this);
    }

    protected abstract void pi(String var1, String var2);

    protected char readChar() throws IOException {
        if (this.myCount >= this.mySize) {
            try {
                this.mySize = this.source.read(this.cb, 0, this.defaultCharBufferSize);
                if (this.mySize < 0) {
                    return '\uffff';
                }
                if (this.mySize == 0) {
                    System.err.println(" DocumentParser::readChar() !!!ERROR !!! source.read(...) == 0");
                    return '\uffff';
                }
                this.myCount = 0;
            }
            catch (CharConversionException charConversionException) {
                throw charConversionException;
            }
            catch (IOException iOException) {
                return '\uffff';
            }
        }
        if (this.shouldCacheSource) {
            this.documentSource.add(this.cb[this.myCount]);
        }
        return this.cb[this.myCount++];
    }

    protected char scanIdentifier(char c10) throws IOException {
        while (c10 == '_' || c10 == ':' || c10 >= '0' && c10 <= '9' || Character.isLetter(c10)) {
            if (this.buffer.buflen >= this.buffer.buf.length) {
                char[] cArray = new char[this.buffer.buf.length * this.buffer.scale];
                System.arraycopy(this.buffer.buf, 0, cArray, 0, this.buffer.buf.length);
                this.buffer.buf = cArray;
            }
            this.buffer.buf[this.buffer.buflen++] = c10;
            if (this.myCount >= this.mySize) {
                try {
                    this.mySize = this.source.read(this.cb, 0, this.defaultCharBufferSize);
                    if (this.mySize < 0) break;
                    if (this.mySize == 0) {
                        System.err.println(" DocumentParser::scanIdentifier() !!!ERROR !!! source.read(...) == 0");
                        break;
                    }
                    this.myCount = 0;
                }
                catch (CharConversionException charConversionException) {
                    throw charConversionException;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            if (this.shouldCacheSource) {
                this.documentSource.add(this.cb[this.myCount]);
            }
            c10 = this.cb[this.myCount++];
        }
        return c10;
    }

    protected char scanQuotedString(char c10) throws IOException {
        if ((c10 = this.skipWhite(c10)) == '\"') {
            while ((c10 = this.readChar()) != '\"' && c10 != '>') {
                this.buffer.add(c10);
            }
            return this.readChar();
        }
        if (c10 == '\'') {
            while ((c10 = this.readChar()) != '\'' && c10 != '>') {
                this.buffer.add(c10);
            }
            return this.readChar();
        }
        return c10;
    }

    public void setInput(InputStream inputStream, String string) throws UnsupportedEncodingException {
        if (inputStream == null) {
            this.source = null;
            return;
        }
        this.source = new MyBufferedReader(new InputStreamReader(inputStream, string));
    }

    public void setInput(Reader reader) {
        this.source = reader instanceof MyBufferedReader ? reader : new MyBufferedReader(reader);
    }

    public void setShouldCacheSource(boolean bl2) {
        this.shouldCacheSource = bl2;
    }

    protected void setXmlEntities(TagProperties tagProperties) {
    }

    protected void skipToCloseAngle(char c10) throws IOException {
        while (true) {
            if (this.buffer.buflen >= this.buffer.buf.length) {
                char[] cArray = new char[this.buffer.buf.length * this.buffer.scale];
                System.arraycopy(this.buffer.buf, 0, cArray, 0, this.buffer.buf.length);
                this.buffer.buf = cArray;
            }
            this.buffer.buf[this.buffer.buflen++] = c10;
            if (c10 == '>') break;
            if (this.myCount >= this.mySize) {
                try {
                    this.mySize = this.source.read(this.cb, 0, this.defaultCharBufferSize);
                    if (this.mySize < 0) break;
                    if (this.mySize == 0) {
                        System.err.println(" DocumentParser::skipToCloseAngle() !!!ERROR !!! source.read(...) == 0");
                        break;
                    }
                    this.myCount = 0;
                }
                catch (CharConversionException charConversionException) {
                    throw charConversionException;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            c10 = this.cb[this.myCount++];
        }
        this.generateError(0);
    }

    protected char skipWhite(char c10) throws IOException {
        while (c10 == ' ' || c10 == '\r' || c10 == '\t' || c10 == '\n') {
            if (this.buffer.buflen >= this.buffer.buf.length) {
                char[] cArray = new char[this.buffer.buf.length * this.buffer.scale];
                System.arraycopy(this.buffer.buf, 0, cArray, 0, this.buffer.buf.length);
                this.buffer.buf = cArray;
            }
            this.buffer.buf[this.buffer.buflen++] = c10;
            if (this.myCount >= this.mySize) {
                try {
                    this.mySize = this.source.read(this.cb, 0, this.defaultCharBufferSize);
                    if (this.mySize < 0) break;
                    if (this.mySize == 0) {
                        System.err.println(" DocumentParser::parse() !!!ERROR !!! source.read(...) == 0");
                        break;
                    }
                    this.myCount = 0;
                }
                catch (CharConversionException charConversionException) {
                    throw charConversionException;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            if (this.shouldCacheSource) {
                this.documentSource.add(this.cb[this.myCount]);
            }
            c10 = this.cb[this.myCount++];
        }
        return c10;
    }

    protected abstract void tag(String var1, TagProperties var2, boolean var3, boolean var4);
}

