/*
 * Decompiled with CFR 0.152.
 */
package com.oroinc.text.regex;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class Perl5StreamInput {
    private static final int __DEFAULT_BUFFER_INCREMENT = 4096;
    private int __bufferIncrement;
    private Reader __input;
    boolean _endOfStream;
    boolean _tentativeEOS;
    int _bufferSize;
    int _streamOffset;
    int _bufferOffset;
    int _matchEndOffset;
    char[] _buffer;
    char[] _originalBuffer;

    public Perl5StreamInput(Reader reader, int n2) {
        this.__input = reader;
        this.__bufferIncrement = n2;
        this._endOfStream = false;
        this._tentativeEOS = false;
        this._streamOffset = 0;
        this._bufferOffset = 0;
        this._bufferSize = 0;
        this._buffer = new char[n2];
        this._originalBuffer = this._buffer;
        this._matchEndOffset = -1;
    }

    public Perl5StreamInput(Reader reader) {
        this(reader, 4096);
    }

    public Perl5StreamInput(InputStream inputStream, int n2) {
        this(new InputStreamReader(inputStream), n2);
    }

    public Perl5StreamInput(InputStream inputStream) {
        this(new InputStreamReader(inputStream), 4096);
    }

    private void __fillBuffer(int n2, int n3) {
        n3 += n2;
        while (n2 < n3) {
            char c10 = this._originalBuffer[n2];
            this._buffer[n2] = Character.isUpperCase(c10) ? Character.toLowerCase(c10) : c10;
            ++n2;
        }
    }

    void _setMatchEndOffset(int n2) {
        this._matchEndOffset = n2;
    }

    int _getMatchEndOffset() {
        return this._matchEndOffset;
    }

    void _reallocate(int n2, boolean bl2) throws IOException {
        if (this._endOfStream) {
            return;
        }
        if (this._tentativeEOS) {
            this._tentativeEOS = false;
            this._endOfStream = true;
            return;
        }
        int n3 = this._bufferSize - n2;
        if (n3 < 0) {
            throw new IOException("Non-negative offset assertion violation.\nPlease report this error to bugs@oroinc.com\n");
        }
        char[] cArray = new char[n3 + this.__bufferIncrement];
        int n4 = this.__input.read(cArray, n3, this.__bufferIncrement);
        if (n4 <= 0) {
            this._endOfStream = true;
            if (n4 == 0) {
                throw new IOException("read from input Reader returned 0 chars.");
            }
        } else {
            this._streamOffset += n2;
            this._bufferSize = n3 + n4;
            while (this._bufferSize < cArray.length) {
                int n5 = this.__input.read(cArray, this._bufferSize, cArray.length - this._bufferSize);
                if (n5 == 0) {
                    throw new IOException("read from input Reader returned 0 chars.");
                }
                if (n5 < 0) {
                    this._tentativeEOS = true;
                    break;
                }
                this._bufferSize += n5;
                n4 += n5;
            }
            System.arraycopy(this._originalBuffer, n2, cArray, 0, n3);
            this._originalBuffer = cArray;
            if (bl2) {
                cArray = new char[n3 + this.__bufferIncrement];
                System.arraycopy(this._buffer, n2, cArray, 0, n3);
                this._buffer = cArray;
                this.__fillBuffer(n3, n4);
                return;
            }
            this._buffer = this._originalBuffer;
        }
    }

    boolean _read(boolean bl2) throws IOException {
        this._streamOffset += this._bufferSize;
        int n2 = this._bufferSize = this.__input.read(this._originalBuffer);
        if (this._bufferSize > 0) {
            while (this._bufferSize < this._originalBuffer.length) {
                n2 = this.__input.read(this._originalBuffer, this._bufferSize, this._originalBuffer.length - this._bufferSize);
                if (n2 == 0) {
                    throw new IOException("read from input Reader returned 0 chars.");
                }
                if (n2 >= 0) {
                    this._bufferSize += n2;
                    continue;
                }
                break;
            }
        } else {
            this._endOfStream = true;
        }
        if (!this._endOfStream && bl2) {
            this._buffer = new char[this._originalBuffer.length];
            this.__fillBuffer(0, this._bufferSize);
        }
        return !this._endOfStream;
    }

    public boolean endOfStream() {
        return this._endOfStream;
    }
}

