/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.subethamail.smtp.command.DataCommand;
import org.subethamail.smtp.command.EhloCommand;
import org.subethamail.smtp.command.HelloCommand;
import org.subethamail.smtp.command.HelpCommand;
import org.subethamail.smtp.command.MailCommand;
import org.subethamail.smtp.command.NoopCommand;
import org.subethamail.smtp.command.QuitCommand;
import org.subethamail.smtp.command.ReceiptCommand;
import org.subethamail.smtp.command.ResetCommand;
import org.subethamail.smtp.command.StartTLSCommand;
import org.subethamail.smtp.command.VerifyCommand;
import org.subethamail.smtp.server.Command;
import org.subethamail.smtp.server.CommandException;
import org.subethamail.smtp.server.ConnectionContext;
import org.subethamail.smtp.server.InvalidCommandNameException;
import org.subethamail.smtp.server.UnknownCommandException;

public class CommandHandler {
    private Map<String, Command> commandMap = new HashMap<String, Command>();
    private static Log log = LogFactory.getLog((Class)(class$org$subethamail$smtp$server$CommandHandler == null ? (class$org$subethamail$smtp$server$CommandHandler = CommandHandler.class$("org.subethamail.smtp.server.CommandHandler")) : class$org$subethamail$smtp$server$CommandHandler));
    private static final /* synthetic */ Class class$org$subethamail$smtp$server$CommandHandler;

    public CommandHandler() {
        this.addCommand(new DataCommand());
        this.addCommand(new EhloCommand());
        this.addCommand(new HelloCommand());
        this.addCommand(new HelpCommand());
        this.addCommand(new MailCommand());
        this.addCommand(new NoopCommand());
        this.addCommand(new QuitCommand());
        this.addCommand(new ReceiptCommand());
        this.addCommand(new ResetCommand());
        this.addCommand(new StartTLSCommand());
        this.addCommand(new VerifyCommand());
    }

    public void addCommand(Command command) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added command: " + command.getName()));
        }
        this.commandMap.put(command.getName(), command);
    }

    public boolean containsCommand(String command) {
        return this.commandMap.containsKey(command);
    }

    public void handleCommand(ConnectionContext context, String commandString) throws SocketTimeoutException, IOException {
        try {
            Command command = this.getCommandFromString(commandString);
            command.execute(commandString, context);
        }
        catch (CommandException e) {
            context.sendResponse("500 " + e.getMessage());
        }
    }

    private Command getCommandFromString(String commandString) throws UnknownCommandException, InvalidCommandNameException {
        String verb;
        Command command = null;
        String key = this.toKey(commandString);
        if (key != null) {
            command = this.commandMap.get(key);
        }
        if (command == null && (verb = this.toVerb(commandString)) != null) {
            command = this.commandMap.get(verb);
        }
        if (command == null) {
            throw new UnknownCommandException("Error: command not implemented");
        }
        return command;
    }

    private String toKey(String string) throws InvalidCommandNameException {
        if (string == null || string.length() < 4) {
            throw new InvalidCommandNameException("Error: bad syntax");
        }
        return string.substring(0, 4).toUpperCase();
    }

    private String toVerb(String string) throws InvalidCommandNameException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new InvalidCommandNameException("Error: bad syntax");
        }
        return stringTokenizer.nextToken().toUpperCase();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

