/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.struts.taglib;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.portals.bridges.struts.PortletServlet;
import org.apache.portals.bridges.struts.StrutsPortletURL;
import org.apache.portals.bridges.struts.config.PortletURLTypes;
import org.apache.portals.bridges.struts.config.StrutsPortletConfig;

class TagsSupport {
    private TagsSupport() {
    }

    public static String getContextRelativeURL(PageContext pageContext, String url, boolean addContextPath) {
        if (!url.startsWith("/")) {
            String newUrl = url;
            String currentPath = (String)pageContext.getRequest().getAttribute("org.apache.portals.bridges.struts.page_url");
            if (addContextPath) {
                currentPath = ((HttpServletRequest)pageContext.getRequest()).getContextPath() + currentPath;
            }
            if (addContextPath || currentPath.length() > 1) {
                currentPath = currentPath.substring(0, currentPath.lastIndexOf(47));
            }
            if (currentPath.length() == 0) {
                currentPath = "/";
            }
            while (currentPath.length() > 0 && newUrl.startsWith("../")) {
                currentPath = currentPath.substring(0, currentPath.lastIndexOf(47));
                newUrl = newUrl.substring(3);
            }
            url = currentPath.length() > 1 ? currentPath + "/" + newUrl : "/" + newUrl;
        }
        return url;
    }

    public static String getURL(PageContext pageContext, String url, PortletURLTypes.URLType type) {
        String contextPath;
        if ((url = TagsSupport.getContextRelativeURL(pageContext, url, false)).startsWith((contextPath = ((HttpServletRequest)pageContext.getRequest()).getContextPath()) + "/")) {
            url = url.substring(contextPath.length());
        }
        if (type == null) {
            StrutsPortletConfig strutsPortletConfig = (StrutsPortletConfig)pageContext.getAttribute("org.apache.portals.bridges.struts.portlet_config", 4);
            type = strutsPortletConfig.getPortletURLTypes().getType(url);
        }
        if (type.equals(PortletURLTypes.URLType.ACTION)) {
            return StrutsPortletURL.createActionURL(pageContext.getRequest(), url).toString();
        }
        if (type.equals(PortletURLTypes.URLType.RENDER)) {
            return StrutsPortletURL.createRenderURL(pageContext.getRequest(), url).toString();
        }
        if (url.startsWith("/")) {
            return contextPath + url;
        }
        return contextPath + "/" + url;
    }

    public static String getFormTagRenderFormStartElement(PageContext pageContext, String formStartElement) {
        if (PortletServlet.isPortletRequest(pageContext.getRequest())) {
            int actionURLStart = formStartElement.indexOf("action=") + 8;
            int actionURLEnd = formStartElement.indexOf(34, actionURLStart);
            String actionURL = formStartElement.substring(actionURLStart, actionURLEnd);
            formStartElement = formStartElement.substring(0, actionURLStart) + StrutsPortletURL.createActionURL(pageContext.getRequest(), actionURL).toString() + formStartElement.substring(actionURLEnd);
        }
        return formStartElement;
    }
}

