/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.Version;
import org.simpleframework.xml.core.AttributeException;
import org.simpleframework.xml.core.Caller;
import org.simpleframework.xml.core.Collector;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.core.ElementException;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.LabelMap;
import org.simpleframework.xml.core.ObjectFactory;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Primitive;
import org.simpleframework.xml.core.Revision;
import org.simpleframework.xml.core.Schema;
import org.simpleframework.xml.core.TextException;
import org.simpleframework.xml.core.Type;
import org.simpleframework.xml.core.ValueRequiredException;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.NodeMap;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Position;

class Composite
implements Converter {
    private final ObjectFactory factory;
    private final Primitive primitive;
    private final Collector store;
    private final Revision revision;
    private final Context context;
    private final Class type;

    public Composite(Context context, Class type) {
        this.factory = new ObjectFactory(context, type);
        this.primitive = new Primitive(context, type);
        this.store = new Collector(context);
        this.revision = new Revision();
        this.context = context;
        this.type = type;
    }

    public Object read(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        if (type.isReference()) {
            return type.getInstance();
        }
        Class real = type.getType();
        if (this.context.isPrimitive(real)) {
            return this.primitive.read(node, real);
        }
        Object source = type.getInstance();
        return this.read(node, source);
    }

    public Object read(InputNode node, Object source) throws Exception {
        Class<?> type = source.getClass();
        Schema schema = this.context.getSchema(type);
        Caller caller = schema.getCaller();
        this.read(node, source, schema);
        this.store.commit(source);
        caller.validate(source);
        caller.commit(source);
        return this.readResolve(node, source, caller);
    }

    private Object readResolve(InputNode node, Object source, Caller caller) throws Exception {
        if (source != null) {
            Position line = node.getPosition();
            Object value = caller.resolve(source);
            Class<?> real = value.getClass();
            if (!this.type.isAssignableFrom(real)) {
                throw new ElementException("Type %s does not match %s at %s", real, this.type, line);
            }
            return value;
        }
        return source;
    }

    private void read(InputNode node, Object source, Schema schema) throws Exception {
        this.readVersion(node, source, schema);
        this.readText(node, source, schema);
        this.readAttributes(node, source, schema);
        this.readElements(node, source, schema);
    }

    private void readVersion(InputNode node, Object source, Schema schema) throws Exception {
        Label label = schema.getVersion();
        if (label != null) {
            String name = label.getName();
            NodeMap<InputNode> map = node.getAttributes();
            InputNode value = map.remove(name);
            if (value != null) {
                this.readVersion(value, source, label);
            } else {
                Version version = this.context.getVersion(this.type);
                Contact contact = label.getContact();
                Double start = this.revision.getDefault();
                Double expected = version.revision();
                contact.set(source, start);
                this.revision.compare(expected, start);
            }
        }
    }

    private void readVersion(InputNode node, Object source, Label label) throws Exception {
        Object value = this.read(node, source, label);
        if (value != null) {
            Version version = this.context.getVersion(this.type);
            Double expected = version.revision();
            if (!value.equals(this.revision)) {
                this.revision.compare(expected, value);
            }
        }
    }

    private void readAttributes(InputNode node, Object source, Schema schema) throws Exception {
        NodeMap<InputNode> list = node.getAttributes();
        LabelMap map = schema.getAttributes();
        for (String name : list) {
            this.readAttribute(node.getAttribute(name), source, map);
        }
        this.validate(node, map, source);
    }

    private void readElements(InputNode node, Object source, Schema schema) throws Exception {
        InputNode child;
        LabelMap map = schema.getElements();
        while ((child = node.getNext()) != null) {
            this.readElement(child, source, map);
        }
        this.validate(node, map, source);
    }

    private void readText(InputNode node, Object source, Schema schema) throws Exception {
        Label label = schema.getText();
        if (label != null) {
            this.read(node, source, label);
        }
    }

    private void readAttribute(InputNode node, Object source, LabelMap map) throws Exception {
        Position line = node.getPosition();
        String name = node.getName();
        Label label = map.take(name);
        if (label == null) {
            if (map.isStrict() && this.revision.isEqual()) {
                throw new AttributeException("Attribute '%s' does not exist at %s", name, line);
            }
        } else {
            this.read(node, source, label);
        }
    }

    private void readElement(InputNode node, Object source, LabelMap map) throws Exception {
        String name = node.getName();
        Label label = map.take(name);
        if (label == null) {
            label = (Label)this.store.get(name);
        }
        if (label == null) {
            Position line = node.getPosition();
            if (map.isStrict() && this.revision.isEqual()) {
                throw new ElementException("Element '%s' does not exist at %s", name, line);
            }
            node.skip();
        } else {
            this.read(node, source, label);
        }
    }

    private Object read(InputNode node, Object source, Label label) throws Exception {
        Object object = this.readObject(node, source, label);
        if (object == null) {
            Position line = node.getPosition();
            Class<?> type = source.getClass();
            if (label.isRequired() && this.revision.isEqual()) {
                throw new ValueRequiredException("Empty value for %s in %s at %s", label, type, line);
            }
        } else if (object != label.getEmpty(this.context)) {
            this.store.put(label, object);
        }
        return object;
    }

    private Object readObject(InputNode node, Object source, Label label) throws Exception {
        Contact contact;
        Object original;
        Converter reader = label.getConverter(this.context);
        if (label.isCollection() && (original = (contact = label.getContact()).get(source)) != null) {
            return reader.read(node, original);
        }
        return reader.read(node);
    }

    private void validate(InputNode node, LabelMap map, Object source) throws Exception {
        Position line = node.getPosition();
        Class<?> type = source.getClass();
        for (Label label : map) {
            if (label.isRequired() && this.revision.isEqual()) {
                throw new ValueRequiredException("Unable to satisfy %s for %s at %s", label, type, line);
            }
            Object value = label.getEmpty(this.context);
            if (value == null) continue;
            this.store.put(label, value);
        }
    }

    public boolean validate(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        if (!type.isReference()) {
            Object real = type.getInstance(type);
            Class expect = type.getType();
            return this.validate(node, expect);
        }
        return true;
    }

    private boolean validate(InputNode node, Class type) throws Exception {
        Schema schema = this.context.getSchema(type);
        this.validateText(node, schema);
        this.validateAttributes(node, schema);
        this.validateElements(node, schema);
        return node.isElement();
    }

    private void validateAttributes(InputNode node, Schema schema) throws Exception {
        NodeMap<InputNode> list = node.getAttributes();
        LabelMap map = schema.getAttributes();
        for (String name : list) {
            this.validateAttribute(node.getAttribute(name), map);
        }
        this.validate(node, map);
    }

    private void validateElements(InputNode node, Schema schema) throws Exception {
        InputNode child;
        LabelMap map = schema.getElements();
        while ((child = node.getNext()) != null) {
            this.validateElement(child, map);
        }
        this.validate(node, map);
    }

    private void validateText(InputNode node, Schema schema) throws Exception {
        Label label = schema.getText();
        if (label != null) {
            this.validate(node, label);
        }
    }

    private void validateAttribute(InputNode node, LabelMap map) throws Exception {
        Position line = node.getPosition();
        String name = node.getName();
        Label label = map.take(name);
        if (label == null) {
            if (map.isStrict() && this.revision.isEqual()) {
                throw new AttributeException("Attribute '%s' does not exist at %s", name, line);
            }
        } else {
            this.validate(node, label);
        }
    }

    private void validateElement(InputNode node, LabelMap map) throws Exception {
        String name = node.getName();
        Label label = map.take(name);
        if (label == null) {
            label = (Label)this.store.get(name);
        }
        if (label == null) {
            Position line = node.getPosition();
            if (map.isStrict() && this.revision.isEqual()) {
                throw new ElementException("Element '%s' does not exist at %s", name, line);
            }
            node.skip();
        } else {
            this.validate(node, label);
        }
    }

    private void validate(InputNode node, Label label) throws Exception {
        Converter reader = label.getConverter(this.context);
        Position line = node.getPosition();
        boolean valid = reader.validate(node);
        if (!valid) {
            throw new PersistenceException("Invalid value for %s in %s at %s", label, this.type, line);
        }
        this.store.put(label, (Object)null);
    }

    private void validate(InputNode node, LabelMap map) throws Exception {
        Position line = node.getPosition();
        for (Label label : map) {
            if (!label.isRequired() || !this.revision.isEqual()) continue;
            throw new ValueRequiredException("Unable to satisfy %s at %s", label, line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputNode node, Object source) throws Exception {
        Class<?> type = source.getClass();
        Schema schema = this.context.getSchema(type);
        Caller caller = schema.getCaller();
        try {
            if (schema.isPrimitive()) {
                this.primitive.write(node, source);
            } else {
                caller.persist(source);
                this.write(node, source, schema);
            }
        }
        finally {
            caller.complete(source);
        }
    }

    private void write(OutputNode node, Object source, Schema schema) throws Exception {
        this.writeVersion(node, source, schema);
        this.writeAttributes(node, source, schema);
        this.writeElements(node, source, schema);
        this.writeText(node, source, schema);
    }

    private void writeVersion(OutputNode node, Object source, Schema schema) throws Exception {
        Version version = schema.getRevision();
        Label label = schema.getVersion();
        if (version != null) {
            Double start = this.revision.getDefault();
            Double value = version.revision();
            if (this.revision.compare(value, start)) {
                if (label.isRequired()) {
                    this.writeAttribute(node, value, label);
                }
            } else {
                this.writeAttribute(node, value, label);
            }
        }
    }

    private void writeAttributes(OutputNode node, Object source, Schema schema) throws Exception {
        LabelMap attributes = schema.getAttributes();
        for (Label label : attributes) {
            Contact contact = label.getContact();
            Object value = contact.get(source);
            if (value == null) {
                value = label.getEmpty(this.context);
            }
            if (value == null && label.isRequired()) {
                throw new AttributeException("Value for %s is null", label);
            }
            this.writeAttribute(node, value, label);
        }
    }

    private void writeElements(OutputNode node, Object source, Schema schema) throws Exception {
        LabelMap elements = schema.getElements();
        for (Label label : elements) {
            Contact contact = label.getContact();
            Object value = contact.get(source);
            if (value == null && label.isRequired()) {
                throw new ElementException("Value for %s is null", label);
            }
            Object replace = this.writeReplace(value);
            if (replace == null) continue;
            this.writeElement(node, replace, label);
        }
    }

    private Object writeReplace(Object source) throws Exception {
        if (source != null) {
            Class<?> type = source.getClass();
            Caller caller = this.context.getCaller(type);
            return caller.replace(source);
        }
        return source;
    }

    private void writeText(OutputNode node, Object source, Schema schema) throws Exception {
        Label label = schema.getText();
        if (label != null) {
            Contact contact = label.getContact();
            Object value = contact.get(source);
            if (value == null) {
                value = label.getEmpty(this.context);
            }
            if (value == null && label.isRequired()) {
                throw new TextException("Value for %s is null", label);
            }
            this.writeText(node, value, label);
        }
    }

    private void writeAttribute(OutputNode node, Object value, Label label) throws Exception {
        if (value != null) {
            Decorator decorator = label.getDecorator();
            String name = label.getName(this.context);
            String text = this.factory.getText(value);
            OutputNode done = node.setAttribute(name, text);
            decorator.decorate(done);
        }
    }

    private void writeElement(OutputNode node, Object value, Label label) throws Exception {
        if (value != null) {
            String name = label.getName(this.context);
            OutputNode next = node.getChild(name);
            Class type = label.getType();
            if (label.isInline() || !this.isOverridden(next, value, type)) {
                Converter convert = label.getConverter(this.context);
                boolean data = label.isData();
                next.setData(data);
                this.writeNamespaces(next, type, label);
                this.writeElement(next, value, convert);
            }
        }
    }

    private void writeElement(OutputNode node, Object value, Converter convert) throws Exception {
        convert.write(node, value);
    }

    private void writeNamespaces(OutputNode node, Class type, Label label) throws Exception {
        Decorator primary = this.context.getDecorator(type);
        Decorator decorator = label.getDecorator();
        decorator.decorate(node, primary);
    }

    private void writeText(OutputNode node, Object value, Label label) throws Exception {
        if (value != null) {
            String text = this.factory.getText(value);
            boolean data = label.isData();
            node.setData(data);
            node.setValue(text);
        }
    }

    private boolean isOverridden(OutputNode node, Object value, Class type) throws Exception {
        return this.factory.setOverride(type, value, node);
    }
}

