/*
 * Decompiled with CFR 0.152.
 */
package nl.captcha.util;

import java.awt.Color;
import java.awt.Font;
import java.lang.reflect.Field;
import java.util.Properties;
import java.util.StringTokenizer;
import nl.captcha.obscurity.BackgroundProducer;
import nl.captcha.obscurity.GimpyEngine;
import nl.captcha.obscurity.NoiseProducer;
import nl.captcha.obscurity.imp.DefaultBackgroundImp;
import nl.captcha.obscurity.imp.DefaultNoiseImp;
import nl.captcha.obscurity.imp.WaterRiple;
import nl.captcha.servlet.CaptchaProducer;
import nl.captcha.servlet.DefaultCaptchaIml;
import nl.captcha.text.TextProducer;
import nl.captcha.text.WordRenederer;
import nl.captcha.text.imp.DefaultTextCreator;
import nl.captcha.text.imp.DefaultWordRenderer;

public class Helper {
    private static Font[] defaultFonts = new Font[]{new Font("Arial", 1, 40), new Font("Courier", 1, 40)};

    public static Font[] getFonts(Properties props) {
        if (props == null) {
            return defaultFonts;
        }
        String fontArr = props.getProperty("cap.font.arr");
        if (fontArr == null) {
            return defaultFonts;
        }
        int fontsize = Helper.getIntegerFromString(props, "cap.font.size");
        if (fontsize < 8) {
            fontsize = 40;
        }
        Font[] fonts = null;
        try {
            StringTokenizer tokeniz = new StringTokenizer(fontArr, ",");
            fonts = new Font[tokeniz.countTokens()];
            int cnt = 0;
            while (tokeniz.hasMoreElements()) {
                Font itf;
                String fontStr = tokeniz.nextToken();
                fonts[cnt] = itf = new Font(fontStr, 1, fontsize);
                ++cnt;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (fonts == null) {
            return defaultFonts;
        }
        return fonts;
    }

    public static int getIntegerFromString(Properties props, String key) {
        int ret = 0;
        if (props == null) {
            return ret;
        }
        String val = props.getProperty(key);
        if (val == null || val.equals("")) {
            return ret;
        }
        try {
            ret = Integer.parseInt(val);
        }
        catch (Exception e) {
            // empty catch block
        }
        return ret;
    }

    private static Color createColor(String rgbalpha) {
        Color c = null;
        try {
            StringTokenizer tok = new StringTokenizer(rgbalpha, ",");
            if (tok.countTokens() < 3) {
                return null;
            }
            int r = Integer.parseInt((String)tok.nextElement());
            int g = Integer.parseInt((String)tok.nextElement());
            int b = Integer.parseInt((String)tok.nextElement());
            if (tok.countTokens() == 1) {
                int a = Integer.parseInt((String)tok.nextElement());
                c = new Color(r, g, b, a);
            } else {
                c = new Color(r, g, b);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }

    public static Color getColor(Properties props, String key, Color defaultc) {
        Color retCol = null;
        if (props == null) {
            return defaultc;
        }
        try {
            String color = props.getProperty(key);
            if (color != null && !color.equals("")) {
                if (color.indexOf(",") > 0) {
                    retCol = Helper.createColor(color);
                } else {
                    Field field = Class.forName("java.awt.Color").getField(color);
                    retCol = (Color)field.get(null);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (retCol == null && defaultc == null) {
            retCol = Color.black;
        } else if (retCol == null) {
            retCol = defaultc;
        }
        return retCol;
    }

    public static final class ThingFactory {
        private String defaultNoiceImpcl = "nl.captcha.obscurity.DefaultNoiseImp";
        public static final int NOICEIMP = 1;
        public static final int OBSIMP = 2;
        public static final int BGIMP = 3;
        public static final int WRDREN = 4;
        public static final int TXTPRDO = 5;
        public static final int CPROD = 6;

        public static Object loadImpl(int type, Properties props) {
            switch (type) {
                case 1: {
                    String nimp = props.getProperty("cap.noise.imp");
                    if (nimp == null) {
                        return new DefaultNoiseImp(props);
                    }
                    try {
                        NoiseProducer nop = (NoiseProducer)Class.forName(nimp).newInstance();
                        nop.setProperties(props);
                        return nop;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return new DefaultNoiseImp(props);
                    }
                }
                case 2: {
                    String obs = props.getProperty("cap.obscurificator");
                    if (obs == null) {
                        return new WaterRiple(props);
                    }
                    try {
                        GimpyEngine gimp = (GimpyEngine)Class.forName(obs).newInstance();
                        gimp.setProperties(props);
                        return gimp;
                    }
                    catch (Exception e) {
                        System.out.print(e.getMessage());
                        return new WaterRiple(props);
                    }
                }
                case 3: {
                    String bg = props.getProperty("cap.bg.imp");
                    if (bg == null) {
                        return new DefaultBackgroundImp(props);
                    }
                    try {
                        BackgroundProducer gimp = (BackgroundProducer)Class.forName(bg).newInstance();
                        gimp.setProperties(props);
                        return gimp;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return new DefaultBackgroundImp(props);
                    }
                }
                case 4: {
                    String wr = props.getProperty("cap.word.imp");
                    if (wr == null) {
                        return new DefaultWordRenderer(props);
                    }
                    try {
                        WordRenederer ren = (WordRenederer)Class.forName(wr).newInstance();
                        ren.setProperties(props);
                        return ren;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return new DefaultWordRenderer(props);
                    }
                }
                case 5: {
                    String txp = props.getProperty("cap.text.producer");
                    if (txp == null) {
                        return new DefaultTextCreator(props);
                    }
                    try {
                        TextProducer txpP = (TextProducer)Class.forName(txp).newInstance();
                        txpP.setProperties(props);
                        return txpP;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return new DefaultTextCreator(props);
                    }
                }
                case 6: {
                    String cp = props.getProperty("cap.producer");
                    if (cp == null) {
                        return new DefaultCaptchaIml(props);
                    }
                    try {
                        CaptchaProducer p = (CaptchaProducer)Class.forName(cp).newInstance();
                        p.setProperties(props);
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return new DefaultCaptchaIml(props);
                    }
                }
            }
            return null;
        }
    }
}

