/*
 * Decompiled with CFR 0.152.
 */
package nl.captcha.text.imp;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.image.BufferedImage;
import java.util.Properties;
import java.util.Random;
import nl.captcha.text.WordRenederer;
import nl.captcha.util.Helper;

public class DefaultWordRenderer
implements WordRenederer {
    private Properties props = null;

    public DefaultWordRenderer(Properties props) {
        this.props = props;
    }

    public DefaultWordRenderer() {
    }

    public BufferedImage renderWord(String word, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2D = image.createGraphics();
        g2D.setColor(Color.black);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        g2D.setRenderingHints(hints);
        Font[] fonts = Helper.getFonts(this.props);
        Random generator = new Random();
        char[] wc = word.toCharArray();
        Color fontColor = Helper.getColor(this.props, "cap.font.color", Color.black);
        g2D.setColor(fontColor);
        FontRenderContext frc = g2D.getFontRenderContext();
        int startPosX = 25;
        for (int i = 0; i < wc.length; ++i) {
            char[] itchar = new char[]{wc[i]};
            int choiceFont = generator.nextInt(fonts.length);
            Font itFont = fonts[choiceFont];
            g2D.setFont(itFont);
            LineMetrics lmet = itFont.getLineMetrics(itchar, 0, itchar.length, frc);
            GlyphVector gv = itFont.createGlyphVector(frc, itchar);
            double charWitdth = gv.getVisualBounds().getWidth();
            g2D.drawChars(itchar, 0, itchar.length, startPosX, 35);
            startPosX = startPosX + (int)charWitdth + 2;
        }
        return image;
    }

    public void setProperties(Properties properties) {
        this.props = properties;
    }
}

