/*
 * Decompiled with CFR 0.152.
 */
package nl.captcha.servlet;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Random;
import nl.captcha.obscurity.BackgroundProducer;
import nl.captcha.obscurity.GimpyEngine;
import nl.captcha.servlet.CaptchaProducer;
import nl.captcha.text.TextProducer;
import nl.captcha.text.WordRenederer;
import nl.captcha.util.Helper;

public class DefaultCaptchaIml
implements CaptchaProducer {
    private Properties props = null;
    private boolean bbox = true;
    private Color boxColor = Color.black;
    private int boxThick = 1;
    private WordRenederer wordRenderer = null;
    private GimpyEngine gimpy = null;
    private BackgroundProducer backGroundImp = null;
    private TextProducer textProducer = null;
    private int w = 200;
    private int h = 50;

    public DefaultCaptchaIml(Properties props) {
        this.props = props;
        if (this.props != null) {
            String height;
            String box = props.getProperty("cap.border");
            this.bbox = box != null && !box.equals("no");
            if (this.bbox) {
                this.boxColor = Helper.getColor(this.props, "cap.border.c", Color.black);
                this.boxThick = Helper.getIntegerFromString(props, "cap.border.th");
                if (this.boxThick == 0) {
                    this.boxThick = 1;
                }
            }
            String wordR = props.getProperty("cap.word.imp");
            this.gimpy = (GimpyEngine)Helper.ThingFactory.loadImpl(2, props);
            this.backGroundImp = (BackgroundProducer)Helper.ThingFactory.loadImpl(3, props);
            this.wordRenderer = (WordRenederer)Helper.ThingFactory.loadImpl(4, props);
            this.textProducer = (TextProducer)Helper.ThingFactory.loadImpl(5, props);
            String width = props.getProperty("cap.image.width");
            if (width != null) {
                this.w = Integer.parseInt(width);
            }
            if ((height = props.getProperty("cap.image.height")) != null) {
                this.h = Integer.parseInt(height);
            }
        }
    }

    public void createImage(OutputStream stream, String text) throws IOException {
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)stream);
        BufferedImage bi = this.wordRenderer.renderWord(text, this.w, this.h);
        this.gimpy.setProperties(this.props);
        bi = this.gimpy.getDistortedImage(bi);
        bi = this.backGroundImp.addBackground(bi);
        Graphics2D graphics = bi.createGraphics();
        if (this.bbox) {
            this.drawBox(graphics);
        }
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bi);
        param.setQuality(1.0f, true);
        encoder.encode(bi, param);
    }

    private static BufferedImage rotate(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage transform = new BufferedImage(width, height, 2);
        Graphics2D g2Dx = (Graphics2D)transform.getGraphics();
        AffineTransform xform = g2Dx.getTransform();
        g2Dx.setBackground(Color.white);
        g2Dx.setColor(Color.white);
        int xRot = width / 2;
        int yRot = height / 2;
        Random rand = new Random();
        int angle = rand.nextInt(5) + 2;
        int ori = rand.nextInt(2);
        if (ori < 1) {
            angle *= -1;
        }
        xform.rotate(Math.toRadians(angle), xRot, yRot);
        g2Dx.setTransform(xform);
        g2Dx.drawImage(image, 0, 0, null, null);
        return transform;
    }

    private void drawBox(Graphics2D graphics) {
        graphics.setColor(this.boxColor);
        if (this.boxThick != 1) {
            BasicStroke stroke = new BasicStroke(this.boxThick);
            graphics.setStroke(stroke);
        }
        Line2D.Double d2 = new Line2D.Double(0.0, 0.0, 0.0, this.w);
        graphics.draw(d2);
        Line2D.Double d3 = new Line2D.Double(0.0, 0.0, this.w, 0.0);
        graphics.draw(d3);
        d3 = new Line2D.Double(0.0, (double)this.h - 1.0, this.w, (double)this.h - 1.0);
        graphics.draw(d3);
        d3 = new Line2D.Double((double)this.w - 1.0, (double)this.h - 1.0, (double)this.w - 1.0, 0.0);
        graphics.draw(d3);
    }

    public void setBackGroundImageProducer(BackgroundProducer background) {
    }

    public void setObscurificator() {
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperties(Properties properties) {
        this.props = properties;
    }

    public void setObscurificator(GimpyEngine engine) {
        this.gimpy = engine;
    }

    public void setTextProducer(TextProducer textP) {
    }

    public String createText() {
        String capText = this.textProducer.getText();
        return capText;
    }

    public void setWordRenderer(WordRenederer renederer) {
        this.wordRenderer = renederer;
    }
}

