/*
 * Decompiled with CFR 0.152.
 */
package nl.captcha.obscurity.imp;

import com.jhlabs.image.RippleFilter;
import com.jhlabs.image.WaterFilter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.util.Properties;
import nl.captcha.obscurity.GimpyEngine;
import nl.captcha.obscurity.NoiseProducer;
import nl.captcha.util.Helper;

public class WaterRiple
implements GimpyEngine {
    private Properties props = null;

    public WaterRiple(Properties props) {
        this.props = props;
    }

    public WaterRiple() {
    }

    public BufferedImage getDistortedImage(BufferedImage image) {
        BufferedImage imageDistorted = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D graph = (Graphics2D)imageDistorted.getGraphics();
        RippleFilter filter = new RippleFilter();
        filter.setWaveType(16);
        filter.setXAmplitude(2.6f);
        filter.setYAmplitude(1.7f);
        filter.setXWavelength(15.0);
        filter.setYWavelength(5.0);
        filter.setEdgeAction(1);
        WaterFilter water = new WaterFilter();
        water.setAmplitude(4.0);
        water.setAntialias(true);
        water.setPhase(15.0);
        water.setWavelength(70.0);
        FilteredImageSource filtered = new FilteredImageSource(image.getSource(), water);
        Image img = Toolkit.getDefaultToolkit().createImage(filtered);
        filtered = new FilteredImageSource(img.getSource(), filter);
        img = Toolkit.getDefaultToolkit().createImage(filtered);
        graph.drawImage(img, 0, 0, null, null);
        graph.dispose();
        NoiseProducer noise = (NoiseProducer)Helper.ThingFactory.loadImpl(1, this.props);
        noise.makeNoise(imageDistorted, 0.1f, 0.1f, 0.25f, 0.25f);
        noise.makeNoise(imageDistorted, 0.1f, 0.25f, 0.5f, 0.9f);
        return imageDistorted;
    }

    public void setProperties(Properties props) {
        this.props = props;
    }
}

