/*
 * Decompiled with CFR 0.152.
 */
package org.stringtree.util.tract;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.stringtree.util.StringUtils;
import org.stringtree.util.Utils;

public class Tract
extends HashMap {
    public static final Tract empty = new Tract();
    public static final String CHARSET = "charset";
    public static final String NAME = "~name";
    public static final String DATE = "~date";
    private String content;

    public Tract() {
        this.setContent(null);
    }

    public Tract(String s) {
        this.setContent(s);
    }

    public Tract(String s, Map attributes) {
        this.putAll(attributes);
        this.setContent(s);
    }

    public Tract(Tract other) {
        this.putAll(other);
        this.setContent(other.getContent());
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public String getAttribute(String name) {
        return StringUtils.stringValue(this.get(name));
    }

    public boolean hasAttribute(String name) {
        return this.containsKey(name);
    }

    public String getAttribute(String name, String dfl) {
        return this.hasAttribute(name) ? this.getAttribute(name) : dfl;
    }

    public void clear() {
        super.clear();
        this.content = null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Tract) {
            Tract other = (Tract)obj;
            Iterator it = this.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (key.startsWith("~") || this.get(key).equals(other.get(key))) continue;
                return false;
            }
            if (!Utils.same(this.content, other.content)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode() ^ this.content.hashCode();
    }

    public Map cloneMap(String contentKey) {
        Map ret = this.cloneMap();
        if (contentKey != null) {
            ret.put(contentKey, this.content);
        }
        return ret;
    }

    public Map cloneMap() {
        HashMap ret = new HashMap();
        ret.putAll(this);
        return ret;
    }

    public String toString() {
        return super.toString() + "[" + StringUtils.nullToEmpty(this.content) + "]";
    }

    public String getCharacterSet() {
        return this.getAttribute(CHARSET, "UTF-8");
    }

    public void setCharacterSet(String charset) {
        this.put(CHARSET, charset);
    }
}

