/*
 * Decompiled with CFR 0.152.
 */
package org.stringtree.juicer.tract;

import org.stringtree.factory.Fetcher;
import org.stringtree.factory.StringFetcher;
import org.stringtree.juicer.AugmentedTransformation;
import org.stringtree.juicer.Initialisable;
import org.stringtree.juicer.regex.MatcherStringFetcher;
import org.stringtree.juicer.string.FactoryRegexReplaceStringFilter;
import org.stringtree.juicer.string.StringStringSource;
import org.stringtree.juicer.tract.RegexTokenFinderTractFilter;
import org.stringtree.util.tract.Tract;

public class RegexSplitReplaceTractFilter
extends RegexTokenFinderTractFilter
implements Initialisable,
AugmentedTransformation {
    protected String to;
    private String prefix;
    private String destpattern;
    private StringFetcher augment;

    public RegexSplitReplaceTractFilter(String from, String to, boolean lock, String prefix, StringFetcher augment) {
        super(from, lock);
        this.to = to;
        this.prefix = prefix;
        this.setAugment(augment);
        this.destpattern = prefix + "([~0123456789]+|" + prefix + ")";
    }

    public RegexSplitReplaceTractFilter(String from, String to, String prefix, StringFetcher augment) {
        this(from, to, true, prefix, augment);
    }

    public RegexSplitReplaceTractFilter(String from, String to, boolean lock, StringFetcher augment) {
        this(from, to, lock, "&", augment);
    }

    public RegexSplitReplaceTractFilter(String from, String to, StringFetcher augment) {
        this(from, to, true, "&", augment);
    }

    public RegexSplitReplaceTractFilter(String from, String to, boolean lock) {
        this(from, to, lock, null);
    }

    public RegexSplitReplaceTractFilter(String from, String to) {
        this(from, to, null);
    }

    public void setAugment(StringFetcher augment) {
        this.augment = augment;
    }

    protected void processToken(Tract ret) {
        MatcherStringFetcher factory = new MatcherStringFetcher(this.matcher, this.prefix, this.augment);
        FactoryRegexReplaceStringFilter dest = new FactoryRegexReplaceStringFilter(this.destpattern, factory, 1);
        dest.connectSource(new StringStringSource(this.to));
        ret.setContent(dest.nextString());
        this.index = this.matcher.end();
        this.find();
    }

    public void init(Fetcher context) {
        if (this.augment instanceof Initialisable) {
            ((Initialisable)((Object)this.augment)).init(context);
        }
    }
}

