/*
 * Decompiled with CFR 0.152.
 */
package com.efsol.friki;

import com.efsol.friki.ClassicToHTMLFilter;
import com.efsol.friki.FileRepository;
import com.efsol.friki.HTMLRenderer;
import com.efsol.friki.Model;
import com.efsol.friki.NamePreserver;
import com.efsol.friki.PageRepository;
import com.efsol.friki.Policy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.stringtree.factory.Fetcher;
import org.stringtree.factory.FetcherHelper;
import org.stringtree.factory.Repository;
import org.stringtree.factory.TractFetcher;
import org.stringtree.factory.flatfiles.DirectoryStringRepository;
import org.stringtree.factory.flatfiles.SuffixFilter;
import org.stringtree.factory.memory.MapStringRepository;
import org.stringtree.factory.resource.ResourceStringFetcher;
import org.stringtree.factory.resource.ResourceTractFetcher;
import org.stringtree.factory.resource.SuffixResourceFilter;
import org.stringtree.util.FileReadingUtils;
import org.stringtree.util.FileUtils;
import org.stringtree.util.FileWritingUtils;
import org.stringtree.util.PropertyFileUtils;
import org.stringtree.util.ResourceUtils;
import org.stringtree.util.StringUtils;
import org.stringtree.util.tract.Tract;

public class FrikiServlet
extends HttpServlet {
    private static final String redirectFileName = "config.txt";
    private static final String settingsFileName = "friki.prp";
    private Model model;
    private Policy policy;
    private Map buttonModes;
    private File tmpDir;
    private File redirect;
    private File baseDir = null;

    private void storeBaseDir(String dir) {
        try {
            FileWritingUtils.writeFile(this.redirect, dir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setPolicy(Policy policy, String name, Object value) {
        if (!policy.contains(name)) {
            policy.put(name, value);
        }
    }

    private void setPolicy(File dir) {
        this.baseDir = dir;
        this.resetPolicy();
    }

    private void resetPolicy() {
        try {
            Properties props;
            this.policy.setBaseDir(this.baseDir);
            File propFile = new File(this.baseDir, settingsFileName);
            System.out.println("Friki: looking for external config file '" + propFile + "'");
            if (propFile.exists() && propFile.canRead()) {
                System.out.println("Friki: reading external config file '" + propFile + "'");
                props = new Properties();
                FileInputStream in = new FileInputStream(propFile);
                props.load(in);
                in.close();
                this.policy.putAll(props);
            }
            this.setPolicy(this.policy, "repository-location", "pages");
            this.setPolicy(this.policy, "template-location", "templates");
            this.setPolicy(this.policy, "transform-spec", "wiki.transform");
            this.setPolicy(this.policy, "button-spec", "buttons.prp");
            this.setPolicy(this.policy, "intermap-spec", "intermap.txt");
            if (!propFile.exists() || propFile.canWrite()) {
                System.out.println("Friki: updating external config file '" + propFile + "'");
                props = new Properties();
                props.putAll((Map<?, ?>)this.policy.getMap());
                FileOutputStream out = new FileOutputStream(propFile);
                props.store(out, "Friki configuration properties");
                out.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        MapStringRepository context = new MapStringRepository();
        PageRepository repository = new PageRepository(new FileRepository(this.policy));
        DirectoryStringRepository templates = new DirectoryStringRepository(this.policy.getFile("template-location"), new SuffixFilter(".tpl"));
        this.ensureDefaults(new ResourceTractFetcher((Object)this), repository, this.policy.get("initialPages"), "dflPages/", "page", true);
        this.ensureDefaults(new ResourceStringFetcher((Object)this, new SuffixResourceFilter(".tpl")), templates, this.policy.get("modes"), "", "template", false);
        this.ensureExists(this.policy.getFile("transform-spec"), "wiki.transform");
        this.ensureExists(this.policy.getFile("button-spec"), "buttons.prp");
        this.ensureExists(this.policy.getFile("intermap-spec"), "intermap.txt");
        ClassicToHTMLFilter filter = new ClassicToHTMLFilter((Fetcher)context, (TractFetcher)repository, ClassicToHTMLFilter.loadRemoteDetails(this.policy.getFile("intermap-spec")), this.policy.getFile("transform-spec"));
        HTMLRenderer renderer = new HTMLRenderer(filter, templates, "<b>Sorry! can't @MODE@ page '@page.name@'</b>");
        this.model = new Model(repository, renderer, filter, this.policy);
        this.buttonModes = PropertyFileUtils.readPropertyFile(this.policy.getFile("button-spec"));
    }

    private void ensureExists(File dest, String resourceName) {
        if (!dest.exists()) {
            try {
                FileWritingUtils.writeFile(dest, ResourceUtils.readResource(resourceName));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void ensureExists(Fetcher fetcher, Repository repository, String prefix, String name, String type, boolean verbose) {
        if (!FetcherHelper.contains(repository, name)) {
            String source = prefix + name;
            Object item = fetcher.getObject(source);
            if (item != null) {
                System.out.println("Initial " + type + " '" + name + "' missing, reinstalling from default.");
                repository.put(name, item);
            } else if (verbose) {
                System.out.println("Initial " + type + " '" + name + "' missing, default not found.");
            }
        }
    }

    private void ensureDefaults(Fetcher fetcher, Repository repository, String list, String prefix, String type, boolean verbose) {
        StringTokenizer tok = new StringTokenizer(list, ", ");
        while (tok.hasMoreTokens()) {
            String name = tok.nextToken();
            this.ensureExists(fetcher, repository, prefix, name, type, verbose);
        }
    }

    private void setRedirect(File check) {
        if (check.canRead()) {
            String content = FileReadingUtils.readFile(check);
            this.setBaseDir(content);
        }
    }

    private void setBaseDir(String content) {
        File dir = "*TMP*".equals(content) ? this.tmpDir : FileUtils.ensureDirectory(content);
        if (dir.isDirectory() && dir.canWrite()) {
            System.out.println("Friki: located external storage dir '" + dir + "'");
            this.storeBaseDir(content);
            this.setPolicy(dir);
        }
    }

    public void init() throws ServletException {
        this.tmpDir = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
        this.policy = new Policy(this.tmpDir);
        this.setPolicy(this.policy, "initialPages", "FrontPage PageFormatting SandBox FrankCarver EfficacySolutionsLimited RecentChanges ReadRequests");
        this.setPolicy(this.policy, "dflPage", "FrontPage");
        this.setPolicy(this.policy, "logReads", "false");
        this.setPolicy(this.policy, "readLogPage", "ReadRequests");
        this.setPolicy(this.policy, "logWrites", "true");
        this.setPolicy(this.policy, "writeLogPage", "RecentChanges");
        this.setPolicy(this.policy, "backupChanges", "true");
        this.setPolicy(this.policy, "backupDir", "old");
        this.setPolicy(this.policy, "modes", "view,edit,search,update,diff");
        this.setPolicy(this.policy, "filterModes", "view,search,diff");
        this.setPolicy(this.policy, "viewMode", "view");
        this.setPolicy(this.policy, "editMode", "edit");
        this.setPolicy(this.policy, "searchMode", "search");
        this.setPolicy(this.policy, "diffMode", "diff");
        this.setPolicy(this.policy, "updateMode", "update");
        this.redirect = new File(this.tmpDir, redirectFileName);
        this.setRedirect(this.redirect);
    }

    private void logLink(String dest, String pageName, String author, boolean diffs) {
        this.model.log(dest, pageName, author, diffs);
    }

    private void show(HttpServletResponse res, String pageName, String mode, String author) throws IOException {
        Tract page;
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        pageName = this.model.ensurePage(pageName);
        mode = this.model.ensureMode(mode);
        if (mode.equals(this.policy.get("searchMode"))) {
            page = this.model.search(pageName);
        } else if (mode.equals(this.policy.get("diffMode"))) {
            page = this.model.get(pageName);
            page.put("diff", this.model.diff(pageName));
        } else {
            page = this.model.get(pageName);
            if (mode.equals(this.policy.get("viewMode")) && "true".equalsIgnoreCase(this.policy.get("logReads"))) {
                this.logLink(this.policy.get("readLogPage"), pageName, author, false);
            }
        }
        boolean filterpage = !"false".equals(page.getAttribute("filter"));
        String filtermodes = this.policy.get("filterModes");
        boolean isFiltered = filterpage && filtermodes != null && filtermodes.indexOf(mode) >= 0;
        this.model.render(page, mode, out, isFiltered);
        ((Writer)out).flush();
    }

    private String getMode(HttpServletRequest req) {
        String mode = req.getServletPath();
        int sep = mode.lastIndexOf("/");
        if (sep > -1) {
            mode = mode.substring(sep);
        }
        mode = mode == null || "".equals(mode) || "/".equals(mode) ? this.policy.get("viewMode") : mode.substring(1);
        return mode;
    }

    private String getEffectiveMode(String mode, HttpServletRequest req) {
        if ("button".equals(mode)) {
            String param = req.getParameter("button");
            mode = (String)this.buttonModes.get(param);
        }
        return mode;
    }

    private String getAuthor(HttpServletRequest req) {
        String ip = req.getRemoteAddr();
        String host = req.getRemoteHost();
        String from = req.getHeader("From");
        boolean gotOne = false;
        StringBuffer buf = new StringBuffer();
        if (!StringUtils.isBlank(ip)) {
            buf.append(ip);
            gotOne = true;
        }
        if (!StringUtils.isBlank(host) && !host.equals(ip)) {
            buf.append("(");
            buf.append(host);
            buf.append(")");
            gotOne = true;
        }
        if (!StringUtils.isBlank(from)) {
            if (gotOne) {
                buf.append(" ");
            }
            buf.append(from);
            gotOne = true;
        }
        if (!gotOne) {
            buf.append("unknown");
        }
        return buf.toString();
    }

    public void doQueryRequest(String mode, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (this.unconfigured(req, res)) {
            return;
        }
        this.show(res, req.getQueryString(), mode, this.getAuthor(req));
    }

    public void doParameterRequest(String mode, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (this.unconfigured(req, res)) {
            return;
        }
        String page = req.getParameter("page");
        String content = req.getParameter("content");
        String author = this.getAuthor(req);
        if ((mode = this.getEffectiveMode(mode, req)).equals("reset")) {
            this.resetPolicy();
            mode = this.policy.get("viewMode");
        }
        if (mode.equals(this.policy.get("updateMode"))) {
            this.model.update(page, content);
            if ("true".equalsIgnoreCase(this.policy.get("logWrites"))) {
                this.logLink(this.policy.get("writeLogPage"), page, author, true);
            }
            res.sendRedirect(this.policy.get("viewMode") + "?" + NamePreserver.escape(page));
        } else if (mode.equals(this.policy.get("searchMode"))) {
            this.show(res, req.getParameter("pattern"), mode, author);
        } else {
            this.show(res, page, mode, author);
        }
    }

    private boolean unconfigured(HttpServletRequest req, HttpServletResponse res) throws IOException {
        boolean ret = false;
        if (this.baseDir == null) {
            String dir = req.getParameter("dir");
            if (!StringUtils.isBlank(dir)) {
                this.setBaseDir(dir);
            } else {
                res.getWriter().write(ResourceUtils.readResource("config.html"));
                ret = true;
            }
        }
        return ret;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String mode = this.getMode(req);
        if ("button".equals(mode)) {
            this.doParameterRequest(mode, req, res);
        } else {
            this.doQueryRequest(mode, req, res);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doParameterRequest(this.getMode(req), req, res);
    }

    public String getServletInfo() {
        return "Friki :- Frank's Wiki";
    }
}

