/*
 * Decompiled with CFR 0.152.
 */
package com.efsol.friki;

import com.efsol.friki.BasicDriver;
import com.efsol.friki.NamePreserver;
import com.efsol.friki.Page;
import com.efsol.friki.Policy;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.stringtree.util.tract.FileTractReader;
import org.stringtree.util.tract.FileTractWriter;
import org.stringtree.util.tract.Tract;

public class FileRepository
extends BasicDriver
implements FilenameFilter {
    private static final DateFormat suffixFormat = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss");
    private String backupDirName;
    private File dir;
    private File backup;
    private boolean backupChanges;
    private Map cache = new HashMap();

    public FileRepository(Policy policy) {
        this.dir = policy.getFile("repository-location");
        System.out.println("Friki: Created File Page Repository at '" + this.dir + "'");
        this.backupChanges = policy.getBoolean("backupChanges");
        this.backupDirName = policy.get("backupDir");
        if (this.backupChanges && this.backupDirName != null) {
            this.backup = new File(this.dir, this.backupDirName);
            this.backup.mkdirs();
        }
        this.cache.put("old/EmptyPage", new Page("old/EmptyPage", "There was no page version before this!"));
    }

    public String escape(String name) {
        return NamePreserver.escape(name);
    }

    public String unescape(String name) {
        return NamePreserver.unescape(name);
    }

    private File pageFile(String name) {
        return new File(this.dir, this.escape(name));
    }

    private File backupFile(String name) {
        int prefix = this.backupDirName.length() + 1;
        String filename = name.substring(prefix);
        return new File(this.backup, this.escape(filename));
    }

    public boolean validName(String name) {
        return (name.indexOf(46) == -1 || name.startsWith(this.backupDirName)) && !this.backupDirName.equals(name);
    }

    public boolean isReadable(String name) {
        return this.validName(name) && name.indexOf(58) == -1 && !name.startsWith("/") && !name.startsWith("\\");
    }

    public boolean isWritable(String name) {
        return this.isReadable(name) && name.indexOf("/") == -1 && name.indexOf("\\") == -1;
    }

    protected void get(File file, Tract ret) {
        if (file.canRead()) {
            try {
                FileTractReader.load(ret, file, true);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public Tract get(String name) {
        if (this.cache.containsKey(name)) {
            return (Tract)this.cache.get(name);
        }
        Page ret = new Page(name);
        File file = name.startsWith(this.backupDirName) ? this.backupFile(name) : this.pageFile(name);
        this.get(file, ret);
        return ret;
    }

    public void put(File file, Tract page) {
        try {
            FileTractWriter.store(page, file);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void put(String name, Tract page) {
        page.put("page.name", name);
        this.put(this.pageFile(name), page);
    }

    public String backup(String name) {
        if (this.backupChanges && this.backup != null) {
            Tract page = this.get(name);
            String dated = "." + suffixFormat.format(new Date());
            File file = new File(this.backup, this.escape(name) + dated);
            this.put(file, page);
            name = this.backupDirName + "/" + name + dated;
        }
        return name;
    }

    public boolean contains(String name) {
        return this.validName(name) && (this.cache.containsKey(name) || this.pageFile(name).canRead());
    }

    public boolean accept(File dir, String name) {
        return this.validName(name);
    }

    public Iterator allPageNames() {
        List<String> names = Arrays.asList(this.dir.list(this));
        ArrayList<String> converted = new ArrayList<String>(names.size());
        Iterator<String> allFiles = names.iterator();
        while (allFiles.hasNext()) {
            converted.add(this.unescape(allFiles.next()));
        }
        Collections.sort(converted);
        return converted.iterator();
    }

    public void append(String name, String text) {
        File page = this.pageFile(name);
        if (page.canWrite()) {
            try {
                FileWriter writer = new FileWriter(page.getAbsolutePath(), true);
                writer.write(text);
                ((Writer)writer).flush();
                ((Writer)writer).close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

