/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.jta;

import javax.naming.InitialContext;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

public class UserTransactionHelper {
    public static final String DEFAULT_USER_TX_LOCATION = "java:comp/UserTransaction";
    private static String userTxURL = "java:comp/UserTransaction";
    static /* synthetic */ Class class$org$quartz$ee$jta$UserTransactionHelper$UserTransactionWithContext;

    private UserTransactionHelper() {
    }

    public static String getUserTxLocation() {
        return userTxURL;
    }

    public static void setUserTxLocation(String userTxURL) {
        if (userTxURL != null) {
            UserTransactionHelper.userTxURL = userTxURL;
        }
    }

    public static UserTransaction lookupUserTransaction() throws SchedulerException {
        return new UserTransactionWithContext();
    }

    public static void returnUserTransaction(UserTransaction userTransaction) {
        if (userTransaction != null && userTransaction instanceof UserTransactionWithContext) {
            UserTransactionWithContext userTransactionWithContext = (UserTransactionWithContext)userTransaction;
            userTransactionWithContext.closeContext();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class UserTransactionWithContext
    implements UserTransaction {
        InitialContext context;
        UserTransaction userTransaction;

        public UserTransactionWithContext() throws SchedulerException {
            try {
                this.context = new InitialContext();
            }
            catch (Throwable t) {
                throw new SchedulerException("UserTransactionHelper failed to create InitialContext to lookup/create UserTransaction.", t);
            }
            try {
                this.userTransaction = (UserTransaction)this.context.lookup(userTxURL);
            }
            catch (Throwable t) {
                this.closeContext();
                throw new SchedulerException("UserTransactionHelper could not lookup/create UserTransaction.", t);
            }
            if (this.userTransaction == null) {
                this.closeContext();
                throw new SchedulerException("UserTransactionHelper could not lookup/create UserTransaction from the InitialContext.");
            }
        }

        public void closeContext() {
            try {
                if (this.context != null) {
                    this.context.close();
                }
            }
            catch (Throwable t) {
                UserTransactionWithContext.getLog().warn((Object)"Failed to close InitialContext used to get a UserTransaction.", t);
            }
            this.context = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.context != null) {
                    UserTransactionWithContext.getLog().warn((Object)"UserTransaction was never returned to the UserTransactionHelper.");
                    this.closeContext();
                }
            }
            finally {
                super.finalize();
            }
        }

        private static Log getLog() {
            return LogFactory.getLog((Class)(class$org$quartz$ee$jta$UserTransactionHelper$UserTransactionWithContext == null ? (class$org$quartz$ee$jta$UserTransactionHelper$UserTransactionWithContext = UserTransactionHelper.class$("org.quartz.ee.jta.UserTransactionHelper$UserTransactionWithContext")) : class$org$quartz$ee$jta$UserTransactionHelper$UserTransactionWithContext));
        }

        public void begin() throws NotSupportedException, SystemException {
            this.userTransaction.begin();
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            this.userTransaction.commit();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.userTransaction.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.userTransaction.setRollbackOnly();
        }

        public int getStatus() throws SystemException {
            return this.userTransaction.getStatus();
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            this.userTransaction.setTransactionTimeout(seconds);
        }
    }
}

