/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.parser.UserAgentStringParserImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OnlineUserAgentStringParserImpl
extends UserAgentStringParserImpl {
    private static final String CHARSET = "UTF-8";
    private static final String CONFIG_FILE = "uadetector/config.properties";
    private static final String DATA_URL_KEY = "data.url";
    private static final long DEFAULT_UPDATE_INTERVAL = 86400000L;
    private static final Logger LOG = LoggerFactory.getLogger(OnlineUserAgentStringParserImpl.class);
    private static final String VERSION_URL_KEY = "version.url";
    private final URL dataUrl;
    private long lastUpdateCheck;
    private long updateInterval = 86400000L;
    private final URL versionUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readConfigProperties() {
        Properties properties = new Properties();
        InputStream stream = OnlineUserAgentStringParserImpl.class.getClassLoader().getResourceAsStream(CONFIG_FILE);
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            LOG.warn(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.warn(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return properties;
    }

    public static String retrieveRemoteVersion(URL url) throws IOException {
        InputStream stream = url.openStream();
        InputStreamReader reader = new InputStreamReader(stream, CHARSET);
        LineNumberReader lnr = new LineNumberReader(reader);
        String line = lnr.readLine();
        lnr.close();
        reader.close();
        stream.close();
        return line;
    }

    public OnlineUserAgentStringParserImpl(InputStream stream) throws MalformedURLException {
        this(stream, OnlineUserAgentStringParserImpl.readConfigProperties());
    }

    public OnlineUserAgentStringParserImpl(InputStream stream, Properties configuration) throws MalformedURLException {
        this(stream, new URL(configuration.getProperty(DATA_URL_KEY)), new URL(configuration.getProperty(VERSION_URL_KEY)));
    }

    public OnlineUserAgentStringParserImpl(InputStream stream, URL dataUrl, URL versionUrl) {
        super(stream);
        if (dataUrl == null) {
            throw new IllegalArgumentException("Argument 'dataUrl' must not be null.");
        }
        if (versionUrl == null) {
            throw new IllegalArgumentException("Argument 'versionUrl' must not be null.");
        }
        this.dataUrl = dataUrl;
        this.versionUrl = versionUrl;
        this.retrieveRemoteData(dataUrl);
    }

    @Override
    protected Data getData() {
        this.retrieveRemoteData(this.dataUrl);
        return super.getData();
    }

    public long getLastUpdateCheck() {
        return this.lastUpdateCheck;
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    private boolean isUpdateAvailable() {
        boolean result = false;
        if (this.lastUpdateCheck == 0L || this.lastUpdateCheck < System.currentTimeMillis() - this.getUpdateInterval()) {
            try {
                String version = OnlineUserAgentStringParserImpl.retrieveRemoteVersion(this.versionUrl);
                if (version.compareTo(this.getCurrentVersion()) > 0) {
                    LOG.debug("An update is available. Current version is '" + this.getCurrentVersion() + "' and remote version is '" + version + "'.");
                    result = true;
                } else {
                    LOG.debug("No update available. Current version is '" + this.getCurrentVersion() + "'.");
                }
            }
            catch (IOException e) {
                LOG.info(e.getLocalizedMessage());
            }
            this.lastUpdateCheck = System.currentTimeMillis();
        } else {
            LOG.debug("There is no check necessary because the update interval has not expired.");
        }
        return result;
    }

    private void retrieveRemoteData(URL url) {
        if (this.isUpdateAvailable()) {
            LOG.debug("Reading remote data...");
            this.setData(this.getDataReader().read(url));
        }
    }

    public void setUpdateInterval(long updateInterval) {
        if (updateInterval < 0L) {
            throw new IllegalArgumentException("Update interval must be not less than 0.");
        }
        this.updateInterval = updateInterval;
    }
}

