/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegularExpressionConverter {
    private static final Pattern PERL_STYLE = Pattern.compile("^/.*/((i|m|s|x)*)?$");
    private static final Pattern PERL_STYLE_TOLERANT = Pattern.compile("^/.*/(([A-z])*)?$");

    public static Pattern convertPerlRegexToPattern(String regex) {
        return RegularExpressionConverter.convertPerlRegexToPattern(regex, false);
    }

    public static Pattern convertPerlRegexToPattern(String regex, boolean faultTolerant) {
        Matcher matcher;
        if (regex == null) {
            throw new IllegalArgumentException("Argument 'regex' must not be null.");
        }
        String pattern = regex.trim();
        Matcher matcher2 = matcher = faultTolerant ? PERL_STYLE_TOLERANT.matcher(pattern) : PERL_STYLE.matcher(pattern);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The given regular expression '" + pattern + "' seems to be not in PERL style or has unsupported modifiers.");
        }
        pattern = pattern.substring(1);
        int lastIndex = pattern.lastIndexOf(47);
        pattern = pattern.substring(0, lastIndex);
        int flags = RegularExpressionConverter.translateModifiers(matcher.group(1));
        return Pattern.compile(pattern, flags);
    }

    public static int translateModifiers(String modifiers) {
        if (modifiers == null) {
            throw new IllegalArgumentException("Argument 'modifiers' must not be null.");
        }
        int flags = 0;
        block6: for (int i = 0; i < modifiers.length(); ++i) {
            char chr = modifiers.charAt(i);
            switch (chr) {
                case 'i': {
                    flags |= 2;
                    continue block6;
                }
                case 'm': {
                    flags |= 8;
                    continue block6;
                }
                case 's': {
                    flags |= 0x20;
                    continue block6;
                }
                case 'x': {
                    flags |= 4;
                    continue block6;
                }
            }
        }
        return flags;
    }

    private RegularExpressionConverter() {
    }
}

