/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.data.domain;

import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.uadetector.UserAgent;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;

public final class OperatingSystem {
    private final String family;
    private final String icon;
    private final int id;
    private final String infoUrl;
    private final String name;
    private final SortedSet<OperatingSystemPattern> patternSet;
    private final String producer;
    private final String producerUrl;
    private final String url;

    public OperatingSystem(String family, String icon, int id, String infoUrl, String name, SortedSet<OperatingSystemPattern> patternSet, String producer, String producerUrl, String url) {
        if (family == null) {
            throw new IllegalArgumentException("Argument 'family' must not be null.");
        }
        if (icon == null) {
            throw new IllegalArgumentException("Argument 'icon' must not be null.");
        }
        if (id < 0) {
            throw new IllegalArgumentException("Argument 'id' must not be smaller than 0.");
        }
        if (infoUrl == null) {
            throw new IllegalArgumentException("Argument 'infoUrl' must not be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' must not be null.");
        }
        if (patternSet == null) {
            throw new IllegalArgumentException("Argument 'patternSet' must not be null.");
        }
        if (producer == null) {
            throw new IllegalArgumentException("Argument 'producer' must not be null.");
        }
        if (producerUrl == null) {
            throw new IllegalArgumentException("Argument 'producerUrl' must not be null.");
        }
        if (url == null) {
            throw new IllegalArgumentException("Argument 'url' must not be null.");
        }
        this.family = family;
        this.id = id;
        this.icon = icon;
        this.infoUrl = infoUrl;
        this.name = name;
        this.patternSet = patternSet;
        this.producer = producer;
        this.producerUrl = producerUrl;
        this.url = url;
    }

    public void copyTo(UserAgent.Builder builder) {
        builder.setOperatingSystem(new net.sf.uadetector.OperatingSystem(this.family, this.name, this.producer, this.producerUrl, this.url));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperatingSystem other = (OperatingSystem)obj;
        if (!this.family.equals(other.family)) {
            return false;
        }
        if (!this.icon.equals(other.icon)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (!this.infoUrl.equals(other.infoUrl)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.patternSet.equals(other.patternSet)) {
            return false;
        }
        if (!this.producer.equals(other.producer)) {
            return false;
        }
        if (!this.producerUrl.equals(other.producerUrl)) {
            return false;
        }
        return this.url.equals(other.url);
    }

    public String getFamily() {
        return this.family;
    }

    public String getIcon() {
        return this.icon;
    }

    public int getId() {
        return this.id;
    }

    public String getInfoUrl() {
        return this.infoUrl;
    }

    public String getName() {
        return this.name;
    }

    public SortedSet<OperatingSystemPattern> getPatternSet() {
        return this.patternSet;
    }

    public String getProducer() {
        return this.producer;
    }

    public String getProducerUrl() {
        return this.producerUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.family.hashCode();
        result = 31 * result + this.icon.hashCode();
        result = 31 * result + this.id;
        result = 31 * result + this.infoUrl.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.patternSet.hashCode();
        result = 31 * result + this.producer.hashCode();
        result = 31 * result + this.producerUrl.hashCode();
        result = 31 * result + this.url.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OperatingSystem [family=");
        builder.append(this.family);
        builder.append(", icon=");
        builder.append(this.icon);
        builder.append(", id=");
        builder.append(this.id);
        builder.append(", infoUrl=");
        builder.append(this.infoUrl);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", patternSet=");
        builder.append(this.patternSet);
        builder.append(", producer=");
        builder.append(this.producer);
        builder.append(", producerUrl=");
        builder.append(this.producerUrl);
        builder.append(", url=");
        builder.append(this.url);
        builder.append("]");
        return builder.toString();
    }

    public static final class Builder {
        private String family = "unknown";
        private String icon = "";
        private int id = Integer.MIN_VALUE;
        private String infoUrl = "";
        private String name = "unknown";
        private final SortedSet<OperatingSystemPattern> patternSet = new TreeSet<OperatingSystemPattern>();
        private String producer = "unknown";
        private String producerUrl = "";
        private String url = "";

        public Builder() {
        }

        protected Builder(Builder builder) {
            if (builder == null) {
                throw new IllegalArgumentException("Argument 'builder' must not be null.");
            }
            this.family = builder.family;
            this.icon = builder.icon;
            this.id = builder.id;
            this.infoUrl = builder.infoUrl;
            this.name = builder.name;
            this.patternSet.addAll(builder.patternSet);
            this.producer = builder.producer;
            this.producerUrl = builder.producerUrl;
            this.url = builder.url;
        }

        public Builder addPatternSet(Set<OperatingSystemPattern> patternSet) {
            if (patternSet == null) {
                throw new IllegalArgumentException("Argument 'patternSet' must not be null.");
            }
            this.patternSet.addAll(patternSet);
            return this;
        }

        public OperatingSystem build() {
            return new OperatingSystem(this.family, this.icon, this.id, this.infoUrl, this.name, this.patternSet, this.producer, this.producerUrl, this.url);
        }

        public Builder copy() {
            return new Builder(this);
        }

        public String getFamily() {
            return this.family;
        }

        public String getIcon() {
            return this.icon;
        }

        public int getId() {
            return this.id;
        }

        public String getInfoUrl() {
            return this.infoUrl;
        }

        public String getName() {
            return this.name;
        }

        public SortedSet<OperatingSystemPattern> getPatternSet() {
            return this.patternSet;
        }

        public String getProducer() {
            return this.producer;
        }

        public String getProducerUrl() {
            return this.producerUrl;
        }

        public String getUrl() {
            return this.url;
        }

        public Builder setFamily(String family) {
            if (family == null) {
                throw new IllegalArgumentException("Argument 'family' must not be null.");
            }
            this.family = family;
            return this;
        }

        public Builder setIcon(String icon) {
            if (icon == null) {
                throw new IllegalArgumentException("Argument 'icon' must not be null.");
            }
            this.icon = icon;
            return this;
        }

        public Builder setId(int id) {
            if (id < 0) {
                throw new IllegalArgumentException("Argument 'id' must not be smaller than 0.");
            }
            this.id = id;
            return this;
        }

        public Builder setId(String id) {
            if (id == null) {
                throw new IllegalArgumentException("Argument 'id' must not be null.");
            }
            this.setId(Integer.parseInt(id));
            return this;
        }

        public Builder setInfoUrl(String infoUrl) {
            if (infoUrl == null) {
                throw new IllegalArgumentException("Argument 'infoUrl' must not be null.");
            }
            this.infoUrl = infoUrl;
            return this;
        }

        public Builder setName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Argument 'name' must not be null.");
            }
            this.name = name;
            return this;
        }

        public Builder setProducer(String producer) {
            if (producer == null) {
                throw new IllegalArgumentException("Argument 'producer' must not be null.");
            }
            this.producer = producer;
            return this;
        }

        public Builder setProducerUrl(String producerUrl) {
            if (producerUrl == null) {
                throw new IllegalArgumentException("Argument 'producerUrl' must not be null.");
            }
            this.producerUrl = producerUrl;
            return this;
        }

        public Builder setUrl(String url) {
            if (url == null) {
                throw new IllegalArgumentException("Argument 'url' must not be null.");
            }
            this.url = url;
            return this;
        }
    }
}

