/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.uadetector.ReadableVersionNumber;
import net.sf.uadetector.internal.util.AlphanumComparator;

public final class VersionNumber
implements ReadableVersionNumber {
    public static final String EMPTY_EXTENSION = "";
    public static final String EMPTY_GROUP = "";
    public static final VersionNumber UNKNOWN = new VersionNumber("");
    private static final char SEPARATOR = '.';
    private static final int MIN_GROUP_SIZE = 3;
    private static final Pattern NUMERIC = Pattern.compile("\\d+");
    private final List<String> groups;
    private final String extension;

    private static boolean isNumeric(String text) {
        return NUMERIC.matcher(text).matches();
    }

    public static List<String> replaceNullValueWithEmptyGroup(List<String> groups) {
        if (groups == null) {
            throw new IllegalArgumentException("Argument 'groups' must not be null.");
        }
        ArrayList<String> result = new ArrayList<String>(groups.size());
        for (String group : groups) {
            if (group == null) {
                result.add("");
                continue;
            }
            result.add(group);
        }
        for (int i = result.size(); i < 3; ++i) {
            result.add("");
        }
        return result;
    }

    private static String toVersionString(List<String> groups) {
        StringBuilder builder = new StringBuilder(6);
        int count = 0;
        for (String segment : groups) {
            if ("".equals(segment)) break;
            if (count > 0) {
                builder.append('.');
            }
            builder.append(segment);
            ++count;
        }
        return builder.toString();
    }

    public VersionNumber(List<String> groups) {
        this(groups, "");
    }

    public VersionNumber(List<String> groups, String extension) {
        if (groups == null) {
            throw new IllegalArgumentException("Argument 'groups' must not be null.");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Argument 'extension' must not be null.");
        }
        List<String> segments = VersionNumber.replaceNullValueWithEmptyGroup(groups);
        int i = 0;
        for (String segment : segments) {
            if (!"".equals(segment) && !VersionNumber.isNumeric(segment)) {
                throw new IllegalArgumentException("The segment on position " + i + " (" + segment + ") must be a number.");
            }
            ++i;
        }
        this.groups = segments;
        this.extension = extension;
    }

    public VersionNumber(String major) {
        this(major, "");
    }

    public VersionNumber(String major, String minor) {
        this(major, minor, "");
    }

    public VersionNumber(String major, String minor, String bugfix) {
        this(major, minor, bugfix, "");
    }

    public VersionNumber(String major, String minor, String bugfix, String extension) {
        this(Arrays.asList(major, minor, bugfix), extension);
    }

    @Override
    public int compareTo(ReadableVersionNumber other) {
        int result = 0;
        if (other == null) {
            result = -1;
        } else if (other.getGroups() == null) {
            result = -1;
        } else {
            AlphanumComparator comparator = new AlphanumComparator();
            int length = this.groups.size() < other.getGroups().size() ? this.groups.size() : other.getGroups().size();
            result = comparator.compare(VersionNumber.toVersionString(this.groups.subList(0, length)), VersionNumber.toVersionString(other.getGroups().subList(0, length)));
            if (result == 0) {
                int n = this.groups.size() > other.getGroups().size() ? 1 : (result = this.groups.size() < other.getGroups().size() ? -1 : 0);
            }
            if (result == 0) {
                result = this.extension.compareTo(other.getExtension());
            }
            if (result == 0) {
                result = comparator.compare(this.toVersionString(), other.toVersionString());
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionNumber other = (VersionNumber)obj;
        if (!((Object)this.groups).equals(other.groups)) {
            return false;
        }
        return this.extension.equals(other.extension);
    }

    @Override
    public String getBugfix() {
        return this.groups.get(2);
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public List<String> getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    @Override
    public String getMajor() {
        return this.groups.get(0);
    }

    @Override
    public String getMinor() {
        return this.groups.get(1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Object)this.groups).hashCode();
        result = 31 * result + this.extension.hashCode();
        return result;
    }

    public String toString() {
        return "VersionNumber [groups=" + this.groups + ", extension=" + this.extension + "]";
    }

    @Override
    public String toVersionString() {
        return VersionNumber.toVersionString(this.groups) + this.extension;
    }
}

