/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.Collection;
import org.simpleframework.xml.core.CollectionFactory;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Traverser;
import org.simpleframework.xml.core.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

class CompositeList
implements Converter {
    private final CollectionFactory factory;
    private final Traverser root;
    private final Class entry;
    private final String name;

    public CompositeList(Context context, Class type, Class entry, String name) {
        this.factory = new CollectionFactory(context, type);
        this.root = new Traverser(context);
        this.entry = entry;
        this.name = name;
    }

    public Object read(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        Object list = type.getInstance();
        if (!type.isReference()) {
            return this.read(node, list);
        }
        return list;
    }

    public Object read(InputNode node, Object result) throws Exception {
        Collection list = (Collection)result;
        InputNode next;
        while ((next = node.getNext()) != null) {
            list.add(this.root.read(next, this.entry));
        }
        return list;
    }

    public boolean validate(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        if (!type.isReference()) {
            Object real = type.getInstance(type);
            Class expect = type.getType();
            return this.validate(node, expect);
        }
        return true;
    }

    private boolean validate(InputNode node, Class type) throws Exception {
        InputNode next;
        while ((next = node.getNext()) != null) {
            this.root.validate(next, this.entry);
        }
        return true;
    }

    public void write(OutputNode node, Object source) throws Exception {
        Collection list = (Collection)source;
        for (Object item : list) {
            if (item == null) continue;
            Class<?> type = item.getClass();
            if (!this.entry.isAssignableFrom(type)) {
                throw new PersistenceException("Entry %s does not match %s", type, this.entry);
            }
            this.root.write(node, item, this.entry, this.name);
        }
    }
}

