/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.jboss.security.android;

import de.proveo.wwt.jboss.security.android.AndroidUsernamePasswordLoginModule;
import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.SimpleGroup;
import org.jboss.security.Util;

public class AndroidLoginModule
extends AndroidUsernamePasswordLoginModule {
    private static final Log log = LogFactory.getLog(AndroidLoginModule.class);
    protected static String dsJndiName;
    protected static final String principalsQuery = "SELECT password FROM use_user a where name = ? AND deleted = 0";
    protected static final String SUPERADMIN = "superadmin";
    protected static String superadminPWD;
    protected static String jmxUser;
    protected static String jmxUserPWD;
    protected static ArrayList<String> saUsers;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        log.debug((Object)"Start initialization");
        dsJndiName = (String)options.get("dsJndiName");
        if (dsJndiName == null) {
            dsJndiName = "java:/DefaultDS";
        }
        Object tmp = options.get("customerId");
        String customerId = "TEST";
        if (tmp != null) {
            customerId = tmp.toString();
        }
        if ((tmp = options.get("superadmin_pwd")) == null || ((String)tmp).length() == 0) {
            tmp = "rts" + customerId + "x1a";
        }
        superadminPWD = Util.createPasswordHash((String)"SHA-1", (String)"HEX", null, null, (String)tmp.toString());
        tmp = options.get("jmxUser");
        if (tmp != null) {
            jmxUser = tmp.toString();
        }
        if ((tmp = options.get("jmxUser_pwd")) == null) {
            tmp = "rts" + customerId + "x1a";
        } else if (tmp != null) {
            jmxUserPWD = tmp.toString();
        }
        tmp = options.get("saUsers");
        if (tmp != null) {
            String users = tmp.toString();
            String[] splittedUsers = users.split(",");
            saUsers = new ArrayList();
            for (int i = 0; i < splittedUsers.length; ++i) {
                saUsers.add(splittedUsers[i].trim());
            }
        }
    }

    protected String convertRawPassword(String rawPassword) {
        return rawPassword;
    }

    protected Group[] getRoleSets() throws LoginException {
        log.debug((Object)"get roles");
        SimpleGroup group = new SimpleGroup("Roles");
        try {
            group.addMember(super.createIdentity("android.user"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Group[] roleSets = new Group[]{group};
        return roleSets;
    }

    @Override
    protected String getUsersPassword() throws LoginException {
        String username = this.getUsername();
        String password = null;
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        if (username.equals(SUPERADMIN)) {
            log.debug((Object)(username + " logged in as superAdmin"));
            return superadminPWD;
        }
        if (username.equals(jmxUser)) {
            log.debug((Object)(username + " logged in as jmxUser"));
            return jmxUserPWD;
        }
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(dsJndiName);
            conn = ds.getConnection();
            ps = conn.prepareStatement(principalsQuery);
            ps.setString(1, username);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new FailedLoginException("No matching username found in Principals");
            }
            password = rs.getString(1);
            password = this.convertRawPassword(password);
        }
        catch (NamingException ex) {
            throw new LoginException(ex.toString(true));
        }
        catch (SQLException ex) {
            log.error((Object)"Query failed", (Throwable)ex);
            throw new LoginException(ex.toString());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    log.debug((Object)"runs into", (Throwable)e);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    log.debug((Object)"runs into", (Throwable)e);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    log.debug((Object)"runs into", (Throwable)e);
                }
            }
        }
        return password;
    }

    static {
        superadminPWD = null;
        jmxUser = "jmxuser";
        jmxUserPWD = null;
    }
}

