/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.jboss.security;

import de.proveo.wwt.jboss.security.EFMAccountUtil;
import de.proveo.wwt.jboss.security.UsernamePasswordLoginModule;
import java.security.Principal;
import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.SimpleGroup;
import org.jboss.security.Util;

public class RTSLoginModule
extends UsernamePasswordLoginModule {
    private static final Log log = LogFactory.getLog(RTSLoginModule.class);
    protected static final String allRolesQuery = "SELECT role_name, 'Roles' FROM role r";
    protected static String dsJndiName;
    protected static final String principalsQuery = "SELECT password FROM account a where username = ? AND block_Out = 0 AND deleted = 0";
    protected static final String isSuperamdinQuery = "SELECT superadmin FROM account a where username = ? AND block_Out = 0 AND deleted = 0";
    protected static final String rolesQuery = "SELECT DISTINCT role_name AS Roles FROM role r WHERE  r.id IN (SELECT id_role FROM   account_x_role WHERE  id_account IN (SELECT id FROM   account WHERE  account.username = ? AND DELETED=0)) OR r.id IN (SELECT id_role FROM   groupident_x_role WHERE  id_groupident IN (SELECT id_groupident FROM   account_x_groupident WHERE id_account IN (SELECT id FROM   account WHERE account.username = ? AND DELETED=0))) OR r.id IN (SELECT id_sectionrole FROM   role_x_role WHERE  id_role IN (SELECT id_role  FROM   groupident_x_role  WHERE  id_groupident IN (SELECT  id_groupident FROM  account_x_groupident WHERE  id_account IN  (SELECT id   FROM   account   WHERE  account.username = ? AND DELETED=0  )))) OR r.id IN (SELECT id_sectionrole FROM   role_x_role WHERE  id_role IN (SELECT id_role  FROM   account_x_role  WHERE  id_account IN (SELECT id  FROM   account  WHERE  account.username = ? AND DELETED=0)))";
    protected static final String SUPERADMIN = "superadmin";
    protected static String superadminPWD;
    protected static String jmxUser;
    protected static String jmxUserPWD;
    protected static ArrayList<String> saUsers;
    protected final EFMAccountUtil accountUtil = new EFMAccountUtil();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        dsJndiName = (String)options.get("dsJndiName");
        if (dsJndiName == null) {
            dsJndiName = "java:/DefaultDS";
        }
        Object tmp = options.get("customerId");
        String customerId = "TEST";
        if (tmp != null) {
            customerId = tmp.toString();
        }
        if ((tmp = options.get("superadmin_pwd")) == null || ((String)tmp).length() == 0) {
            tmp = "rts" + customerId + "x1a";
        }
        superadminPWD = Util.createPasswordHash((String)"SHA-1", (String)"HEX", null, null, (String)tmp.toString());
        tmp = options.get("jmxUser");
        if (tmp != null) {
            jmxUser = tmp.toString();
        }
        if ((tmp = options.get("jmxUser_pwd")) == null) {
            tmp = "rts" + customerId + "x1a";
        } else if (tmp != null) {
            jmxUserPWD = tmp.toString();
        }
        tmp = options.get("saUsers");
        if (tmp != null) {
            String users = tmp.toString();
            String[] splittedUsers = users.split(",");
            saUsers = new ArrayList();
            for (int i = 0; i < splittedUsers.length; ++i) {
                saUsers.add(splittedUsers[i].trim());
            }
        }
        this.accountUtil.setDsJndiName(dsJndiName);
    }

    protected String convertRawPassword(String rawPassword) {
        return rawPassword;
    }

    protected Group[] getRoleSets() throws LoginException {
        String username = this.getUsername();
        Connection conn = null;
        HashMap<String, SimpleGroup> setsMap = new HashMap<String, SimpleGroup>();
        Statement ps = null;
        ResultSet rs = null;
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(dsJndiName);
            conn = ds.getConnection();
            SimpleGroup group = new SimpleGroup("Roles");
            setsMap.put("Roles", group);
            group = (Group)setsMap.get("Roles");
            boolean isSuperadmin = false;
            try {
                group.addMember(super.createIdentity("users"));
                log.debug((Object)"Assign user to role users");
                if (username.equals(SUPERADMIN)) {
                    isSuperadmin = true;
                    group.addMember(super.createIdentity(SUPERADMIN));
                    log.debug((Object)("Assign " + username + " to role superAdmin"));
                } else {
                    ps = conn.prepareStatement(isSuperamdinQuery);
                    ps.setString(1, username);
                    rs = ps.executeQuery();
                    if (!rs.next()) {
                        throw new FailedLoginException("No matching username found in Principals");
                    }
                    isSuperadmin = rs.getBoolean(1);
                    if (isSuperadmin) {
                        group.addMember(super.createIdentity(SUPERADMIN));
                        log.debug((Object)("Assign " + username + " to role superAdmin"));
                    }
                    if (saUsers != null) {
                        for (String saUser : saUsers) {
                            if (!saUser.equalsIgnoreCase(username)) continue;
                            group.addMember(super.createIdentity(SUPERADMIN));
                            log.debug((Object)("Assign " + saUser + " to role superAdmin"));
                        }
                    }
                }
            }
            catch (Exception e) {
                log.debug((Object)"runs into", (Throwable)e);
            }
            if (isSuperadmin) {
                ps = conn.prepareStatement(allRolesQuery);
            } else {
                ps = conn.prepareStatement(rolesQuery);
                for (int i = 1; i != 5; ++i) {
                    ps.setString(i, username);
                }
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                StringBuilder sb = new StringBuilder("Assign user to role(s):");
                boolean isFirst = true;
                do {
                    String name = rs.getString(1);
                    String groupName = "Roles";
                    group = (Group)setsMap.get(groupName);
                    try {
                        Principal p = super.createIdentity(name);
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            sb.append(",");
                        }
                        sb.append(" ");
                        sb.append(name);
                        group.addMember(p);
                    }
                    catch (Exception e) {
                        log.debug((Object)("Failed to create principal: " + name), (Throwable)e);
                    }
                } while (rs.next());
                log.debug((Object)sb.toString());
            }
        }
        catch (NamingException ex) {
            throw new LoginException(ex.toString(true));
        }
        catch (SQLException ex) {
            log.error((Object)"SQL failure", (Throwable)ex);
            throw new LoginException(ex.toString());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    log.debug((Object)"runs into", (Throwable)e);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    log.debug((Object)"runs into", (Throwable)e);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    log.debug((Object)"runs into", (Throwable)e);
                }
            }
        }
        Group[] roleSets = new Group[setsMap.size()];
        setsMap.values().toArray(roleSets);
        return roleSets;
    }

    @Override
    protected String getUsersPassword() throws LoginException {
        String username = this.getUsername();
        String password = null;
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        if (username.equals(SUPERADMIN)) {
            log.debug((Object)(username + " logged in as superAdmin"));
            return superadminPWD;
        }
        if (username.equals(jmxUser)) {
            log.debug((Object)(username + " logged in as jmxUser"));
            return jmxUserPWD;
        }
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(dsJndiName);
            conn = ds.getConnection();
            ps = conn.prepareStatement(principalsQuery);
            ps.setString(1, username);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new FailedLoginException("No matching username found in Principals");
            }
            password = rs.getString(1);
            password = this.convertRawPassword(password);
        }
        catch (NamingException ex) {
            throw new LoginException(ex.toString(true));
        }
        catch (SQLException ex) {
            log.error((Object)"Query failed", (Throwable)ex);
            throw new LoginException(ex.toString());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    log.debug((Object)"runs into", (Throwable)e);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    log.debug((Object)"runs into", (Throwable)e);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    log.debug((Object)"runs into", (Throwable)e);
                }
            }
        }
        return password;
    }

    @Override
    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        String username = this.getUsername();
        try {
            if (!this.accountUtil.isLocalAccount(username)) {
                return false;
            }
        }
        catch (SQLException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("validatePassword runs for " + username + " into"), (Throwable)ex);
            }
            return false;
        }
        return super.validatePassword(inputPassword, expectedPassword);
    }

    static {
        superadminPWD = null;
        jmxUser = "jmxuser";
        jmxUserPWD = null;
    }
}

