/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.rewriter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.portletbridge.PortletBridgeException;
import org.portletbridge.StyleSheetRewriter;
import org.portletbridge.UrlRewriter;

public class RegExStyleSheetRewriter
implements StyleSheetRewriter {
    private UrlRewriter urlRewriter = null;
    private Pattern urlPattern = Pattern.compile("(url\\((?:'|\")?)(.*?)((?:'|\")?\\))");
    private Pattern importPattern = Pattern.compile("(@import\\s+[^url](?:'|\")?)(.*?)((?:'|\")|;|\\s+|$)");

    public RegExStyleSheetRewriter(UrlRewriter urlRewriter) {
        this.urlRewriter = urlRewriter;
    }

    public StringBuffer rewriteUrls(StringBuffer css) throws PortletBridgeException {
        if (css == null) {
            return null;
        }
        Matcher matcher = this.urlPattern.matcher(css);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String before = matcher.group(1);
            String url = matcher.group(2);
            String after = matcher.group(3);
            matcher.appendReplacement(sb, before + this.urlRewriter.rewrite(url) + after);
        }
        matcher.appendTail(sb);
        return sb;
    }

    public StringBuffer rewriteImports(StringBuffer css) throws PortletBridgeException {
        if (css == null) {
            return null;
        }
        Matcher matcher = this.importPattern.matcher(css);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String before = matcher.group(1);
            String url = matcher.group(2);
            String after = matcher.groupCount() == 3 ? matcher.group(3) : "";
            matcher.appendReplacement(sb, before + this.urlRewriter.rewrite(url) + after);
        }
        matcher.appendTail(sb);
        return sb;
    }

    public String rewrite(String css) throws PortletBridgeException {
        return this.rewriteUrls(this.rewriteImports(new StringBuffer(css))).toString();
    }
}

