/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.parser;

import java.util.Map;
import java.util.regex.Matcher;
import net.sf.uadetector.OperatingSystem;
import net.sf.uadetector.UserAgent;
import net.sf.uadetector.UserAgentStringParser;
import net.sf.uadetector.VersionNumber;
import net.sf.uadetector.internal.data.Data;
import net.sf.uadetector.internal.data.domain.Browser;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.internal.data.domain.OperatingSystemPattern;
import net.sf.uadetector.internal.data.domain.Robot;
import net.sf.uadetector.internal.util.VersionParser;

public abstract class AbstractUserAgentStringParser
implements UserAgentStringParser {
    private static void examineAsBrowser(String userAgent, UserAgent.Builder builder, Data data) {
        for (Map.Entry<BrowserPattern, Browser> entry : data.getPatternBrowserMap().entrySet()) {
            Matcher matcher = entry.getKey().getPattern().matcher(userAgent);
            if (!matcher.find()) continue;
            entry.getValue().copyTo(builder);
            VersionNumber version = VersionParser.parseVersion(matcher.groupCount() > 0 ? matcher.group(1) : "");
            builder.setVersionNumber(version);
            break;
        }
    }

    private static boolean examineAsRobot(String userAgent, UserAgent.Builder builder, Data data) {
        boolean isRobot = false;
        for (Robot robot : data.getRobots()) {
            if (!robot.getUserAgentString().equals(userAgent)) continue;
            isRobot = true;
            robot.copyTo(builder);
            VersionNumber version = VersionParser.parseLastVersionNumber(robot.getName());
            builder.setVersionNumber(version);
            break;
        }
        return isRobot;
    }

    private static void examineOperatingSystem(String userAgent, UserAgent.Builder builder, Data data) {
        if (OperatingSystem.EMPTY.equals(builder.getOperatingSystem())) {
            for (Map.Entry<OperatingSystemPattern, net.sf.uadetector.internal.data.domain.OperatingSystem> entry : data.getPatternOsMap().entrySet()) {
                Matcher matcher = entry.getKey().getPattern().matcher(userAgent);
                if (!matcher.find()) continue;
                entry.getValue().copyTo(builder);
                break;
            }
        }
    }

    protected abstract Data getData();

    @Override
    public UserAgent parse(String userAgent) {
        UserAgent.Builder builder = new UserAgent.Builder();
        Data data = this.getData();
        if (!AbstractUserAgentStringParser.examineAsRobot(userAgent, builder, data)) {
            AbstractUserAgentStringParser.examineAsBrowser(userAgent, builder, data);
            AbstractUserAgentStringParser.examineOperatingSystem(userAgent, builder, data);
        }
        return builder.build();
    }
}

