/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.data.domain;

public final class BrowserType {
    private final int id;
    private final String name;

    public BrowserType(int id, String name) {
        if (id < 0) {
            throw new IllegalArgumentException("Argument 'id' must not be smaller than 0.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' must not be null.");
        }
        this.id = id;
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BrowserType other = (BrowserType)obj;
        if (this.id != other.id) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BrowserType [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append("]");
        return builder.toString();
    }

    public static final class Builder {
        private int id = Integer.MIN_VALUE;
        private String name;

        public BrowserType build() {
            return new BrowserType(this.id, this.name);
        }

        public Builder setId(int id) {
            if (id < 0) {
                throw new IllegalArgumentException("Argument 'id' must not be smaller than 0.");
            }
            this.id = id;
            return this;
        }

        public Builder setId(String id) {
            if (id == null) {
                throw new IllegalArgumentException("Argument 'id' must not be null.");
            }
            this.setId(Integer.parseInt(id));
            return this;
        }

        public Builder setName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Argument 'name' must not be null.");
            }
            this.name = name;
            return this;
        }
    }
}

