/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.data.domain;

import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.uadetector.UserAgent;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.internal.data.domain.BrowserType;
import net.sf.uadetector.internal.data.domain.OperatingSystem;

public final class Browser {
    private final String family;
    private final String icon;
    private final int id;
    private final String infoUrl;
    private final OperatingSystem operatingSystem;
    private final SortedSet<BrowserPattern> patternSet;
    private final String producer;
    private final String producerUrl;
    private final BrowserType type;
    private final String url;

    public Browser(int id, BrowserType type, String family, String url, String producer, String producerUrl, String icon, String infoUrl, SortedSet<BrowserPattern> patternSet, OperatingSystem operatingSystem) {
        if (family == null) {
            throw new IllegalArgumentException("Argument 'family' must not be null.");
        }
        if (icon == null) {
            throw new IllegalArgumentException("Argument 'icon' must not be null.");
        }
        if (id < 0) {
            throw new IllegalArgumentException("Argument 'id' must not be smaller than 0.");
        }
        if (infoUrl == null) {
            throw new IllegalArgumentException("Argument 'infoUrl' must not be null.");
        }
        if (patternSet == null) {
            throw new IllegalArgumentException("Argument 'patternSet' must not be null.");
        }
        if (producer == null) {
            throw new IllegalArgumentException("Argument 'producer' must not be null.");
        }
        if (producerUrl == null) {
            throw new IllegalArgumentException("Argument 'producerUrl' must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 'type' must not be null.");
        }
        if (url == null) {
            throw new IllegalArgumentException("Argument 'url' must not be null.");
        }
        this.family = family;
        this.icon = icon;
        this.id = id;
        this.infoUrl = infoUrl;
        this.operatingSystem = operatingSystem;
        this.patternSet = patternSet;
        this.producer = producer;
        this.producerUrl = producerUrl;
        this.type = type;
        this.url = url;
    }

    public void copyTo(UserAgent.Builder builder) {
        builder.setFamily(this.family);
        builder.setName(this.family);
        builder.setProducer(this.producer);
        builder.setProducerUrl(this.producerUrl);
        builder.setType(this.type.getName());
        builder.setUrl(this.url);
        if (this.operatingSystem != null) {
            this.operatingSystem.copyTo(builder);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Browser other = (Browser)obj;
        if (!this.family.equals(other.family)) {
            return false;
        }
        if (!this.icon.equals(other.icon)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (!this.infoUrl.equals(other.infoUrl)) {
            return false;
        }
        if (this.operatingSystem == null ? other.operatingSystem != null : !this.operatingSystem.equals(other.operatingSystem)) {
            return false;
        }
        if (!this.patternSet.equals(other.patternSet)) {
            return false;
        }
        if (!this.producer.equals(other.producer)) {
            return false;
        }
        if (!this.producerUrl.equals(other.producerUrl)) {
            return false;
        }
        if (!this.type.equals(other.type)) {
            return false;
        }
        return this.url.equals(other.url);
    }

    public String getFamily() {
        return this.family;
    }

    public String getIcon() {
        return this.icon;
    }

    public int getId() {
        return this.id;
    }

    public String getInfoUrl() {
        return this.infoUrl;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public SortedSet<BrowserPattern> getPatternSet() {
        return this.patternSet;
    }

    public String getProducer() {
        return this.producer;
    }

    public String getProducerUrl() {
        return this.producerUrl;
    }

    public BrowserType getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.family.hashCode();
        result = 31 * result + this.icon.hashCode();
        result = 31 * result + this.id;
        result = 31 * result + this.infoUrl.hashCode();
        result = 31 * result + (this.operatingSystem == null ? 0 : this.operatingSystem.hashCode());
        result = 31 * result + this.patternSet.hashCode();
        result = 31 * result + this.producer.hashCode();
        result = 31 * result + this.producerUrl.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.url.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Browser [family=");
        builder.append(this.family);
        builder.append(", icon=");
        builder.append(this.icon);
        builder.append(", id=");
        builder.append(this.id);
        builder.append(", infoUrl=");
        builder.append(this.infoUrl);
        builder.append(", operatingSystem=");
        builder.append(this.operatingSystem);
        builder.append(", patternSet=");
        builder.append(this.patternSet);
        builder.append(", producer=");
        builder.append(this.producer);
        builder.append(", producerUrl=");
        builder.append(this.producerUrl);
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", url=");
        builder.append(this.url);
        builder.append("]");
        return builder.toString();
    }

    public static final class Builder {
        private String family = "unknown";
        private String icon = "";
        private int id = Integer.MIN_VALUE;
        private String infoUrl = "";
        private OperatingSystem operatingSystem;
        private SortedSet<BrowserPattern> patternSet = new TreeSet<BrowserPattern>();
        private String producer = "";
        private String producerUrl = "";
        private BrowserType type;
        private int typeId = Integer.MIN_VALUE;
        private String url = "";

        public Builder() {
        }

        protected Builder(Builder builder) {
            if (builder == null) {
                throw new IllegalArgumentException("Argument 'builder' must not be null.");
            }
            this.family = builder.family;
            this.icon = builder.icon;
            this.id = builder.id;
            this.infoUrl = builder.infoUrl;
            this.operatingSystem = builder.operatingSystem;
            this.patternSet = builder.patternSet;
            this.producer = builder.producer;
            this.producerUrl = builder.producerUrl;
            this.type = builder.type;
            this.typeId = builder.typeId;
            this.url = builder.url;
        }

        public Browser build() {
            return new Browser(this.id, this.type, this.family, this.url, this.producer, this.producerUrl, this.icon, this.infoUrl, this.patternSet, this.operatingSystem);
        }

        public Builder copy() {
            return new Builder(this);
        }

        public String getFamily() {
            return this.family;
        }

        public String getIcon() {
            return this.icon;
        }

        public int getId() {
            return this.id;
        }

        public String getInfoUrl() {
            return this.infoUrl;
        }

        public OperatingSystem getOperatingSystem() {
            return this.operatingSystem;
        }

        public SortedSet<BrowserPattern> getPatternSet() {
            return this.patternSet;
        }

        public String getProducer() {
            return this.producer;
        }

        public String getProducerUrl() {
            return this.producerUrl;
        }

        public BrowserType getType() {
            return this.type;
        }

        public int getTypeId() {
            return this.typeId;
        }

        public String getUrl() {
            return this.url;
        }

        public Builder setFamily(String family) {
            if (family == null) {
                throw new IllegalArgumentException("Argument 'family' must not be null.");
            }
            this.family = family;
            return this;
        }

        public Builder setIcon(String icon) {
            if (icon == null) {
                throw new IllegalArgumentException("Argument 'icon' must not be null.");
            }
            this.icon = icon;
            return this;
        }

        public Builder setId(int id) {
            if (id < 0) {
                throw new IllegalArgumentException("Argument 'icon' can not be smaller than 0.");
            }
            this.id = id;
            return this;
        }

        public Builder setId(String id) {
            if (id == null) {
                throw new IllegalArgumentException("Argument 'icon' must not be null.");
            }
            this.setId(Integer.parseInt(id));
            return this;
        }

        public Builder setInfoUrl(String infoUrl) {
            if (infoUrl == null) {
                throw new IllegalArgumentException("Argument 'infoUrl' must not be null.");
            }
            this.infoUrl = infoUrl;
            return this;
        }

        public Builder setOperatingSystem(OperatingSystem operatingSystem) {
            if (operatingSystem == null) {
                throw new IllegalArgumentException("Argument 'operatingSystem' must not be null.");
            }
            this.operatingSystem = operatingSystem;
            return this;
        }

        public Builder setPatternSet(SortedSet<BrowserPattern> patternSet) {
            if (patternSet == null) {
                throw new IllegalArgumentException("Argument 'patternSet' must not be null.");
            }
            this.patternSet = patternSet;
            return this;
        }

        public Builder setProducer(String producer) {
            if (producer == null) {
                throw new IllegalArgumentException("Argument 'producer' must not be null.");
            }
            this.producer = producer;
            return this;
        }

        public Builder setProducerUrl(String producerUrl) {
            if (producerUrl == null) {
                throw new IllegalArgumentException("Argument 'producerUrl' must not be null.");
            }
            this.producerUrl = producerUrl;
            return this;
        }

        public Builder setType(BrowserType type) {
            if (type == null) {
                throw new IllegalArgumentException("Argument 'type' must not be null.");
            }
            this.type = type;
            return this;
        }

        public Builder setTypeId(int typeId) {
            if (typeId < 0) {
                throw new IllegalArgumentException("Argument 'typeId' can not be smaller than 0.");
            }
            this.typeId = typeId;
            return this;
        }

        public Builder setTypeId(String typeId) {
            if (typeId == null) {
                throw new IllegalArgumentException("Argument 'typeId' must not be null.");
            }
            this.setTypeId(Integer.parseInt(typeId));
            return this;
        }

        public Builder setUrl(String url) {
            if (url == null) {
                throw new IllegalArgumentException("Argument 'url' must not be null.");
            }
            this.url = url;
            return this;
        }
    }
}

