/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.cache.CacheRequest;
import org.eclipse.birt.data.engine.executor.cache.CacheUtil;
import org.eclipse.birt.data.engine.executor.cache.ExpandableRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.MemoryCache;
import org.eclipse.birt.data.engine.executor.cache.OdiAdapter;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.SizeOfUtil;
import org.eclipse.birt.data.engine.executor.cache.SmartCache;
import org.eclipse.birt.data.engine.executor.cache.SmartCacheRequest;
import org.eclipse.birt.data.engine.executor.cache.SortSpec;
import org.eclipse.birt.data.engine.executor.cache.disk.DiskCache;
import org.eclipse.birt.data.engine.expression.CompareHints;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

class SmartCacheHelper {
    private ResultSetCache resultSetCache;
    private IEventHandler eventHandler;
    private static Logger logger = Logger.getLogger(SmartCache.class.getName());
    private DataEngineSession session;

    SmartCacheHelper(DataEngineSession session) {
        this.session = session;
    }

    ResultSetCache getResultSetCache(CacheRequest cacheRequest, ResultSet odaResultSet, IResultClass rsMeta) throws DataException {
        assert (cacheRequest != null);
        assert (odaResultSet != null);
        assert (rsMeta != null);
        if (cacheRequest.getDistinctValueFlag()) {
            SmartCacheHelper smartCacheHelper = new SmartCacheHelper(this.session);
            ResultSetCache smartCache = smartCacheHelper.getDistinctResultSetCache(cacheRequest, new OdiAdapter(odaResultSet, rsMeta), rsMeta);
            cacheRequest.setDistinctValueFlag(false);
            this.initInstance(cacheRequest, new OdiAdapter(smartCache), rsMeta);
        } else {
            this.initOdaResult(cacheRequest, new OdiAdapter(odaResultSet, rsMeta), rsMeta);
        }
        return this.resultSetCache;
    }

    private ResultSetCache getDistinctResultSetCache(CacheRequest cacheRequest, OdiAdapter odiAdapter, IResultClass rsMeta) throws DataException {
        SmartCacheHelper smartCacheHelper = new SmartCacheHelper(this.session);
        ResultSetCache smartCache = smartCacheHelper.getSortedResultSetCache(new CacheRequest(0, null, SmartCacheHelper.getSortSpec(rsMeta), cacheRequest.getEventHandler(), true), odiAdapter, rsMeta);
        this.initInstance(cacheRequest, new OdiAdapter(smartCache), rsMeta);
        return this.resultSetCache;
    }

    private static SortSpec getSortSpec(IResultClass rsMeta) {
        int fieldCount = rsMeta.getFieldCount();
        int[] sortKeyIndexs = new int[fieldCount];
        String[] sortKeyNames = new String[fieldCount];
        int[] ascending = new int[fieldCount];
        CompareHints[] comparator = new CompareHints[fieldCount];
        int i = 0;
        while (i < fieldCount) {
            sortKeyIndexs[i] = i + 1;
            ascending[i] = 0;
            ++i;
        }
        return new SortSpec(sortKeyIndexs, sortKeyNames, ascending, comparator);
    }

    private ResultSetCache getSortedResultSetCache(CacheRequest cacheRequest, OdiAdapter odiAdapter, IResultClass rsMeta) throws DataException {
        this.initOdaResult(cacheRequest, odiAdapter, rsMeta);
        return this.resultSetCache;
    }

    private void initOdaResult(CacheRequest cacheRequest, OdiAdapter odiAdpater, IResultClass rsMeta) throws DataException {
        this.initInstance(cacheRequest, odiAdpater, rsMeta);
    }

    ResultSetCache getResultSetCache(CacheRequest cacheRequest, ResultSetCache resultCache, int startIndex, int endIndex, IResultClass rsMeta) throws DataException {
        assert (cacheRequest != null);
        assert (resultCache != null);
        assert (rsMeta != null);
        OdiAdapter odiAdpater = new OdiAdapter(resultCache);
        this.initSubResult(cacheRequest, resultCache, odiAdpater, startIndex, endIndex, rsMeta);
        return this.resultSetCache;
    }

    private void initSubResult(CacheRequest cacheRequest, ResultSetCache resultCache, OdiAdapter odiAdpater, int startIndex, int endIndex, IResultClass rsMeta) throws DataException {
        int length = endIndex - startIndex;
        if (cacheRequest.getMaxRow() <= 0 || length <= cacheRequest.getMaxRow()) {
            cacheRequest.setMaxRow(length);
        }
        int oldIndex = resultCache.getCurrentIndex();
        if (startIndex == 0) {
            resultCache.reset();
        } else {
            resultCache.moveTo(startIndex - 1);
        }
        this.initInstance(cacheRequest, odiAdpater, rsMeta);
        resultCache.moveTo(oldIndex);
    }

    ResultSetCache getResultSetCache(CacheRequest cacheRequest, OdiAdapter odiAdapter, IResultClass rsMeta) throws DataException {
        if (cacheRequest.getDistinctValueFlag()) {
            SmartCacheHelper smartCacheHelper = new SmartCacheHelper(this.session);
            ResultSetCache smartCache = smartCacheHelper.getDistinctResultSetCache(cacheRequest, odiAdapter, rsMeta);
            cacheRequest.setDistinctValueFlag(false);
            this.initInstance(cacheRequest, new OdiAdapter(smartCache), rsMeta);
        } else {
            this.initInstance(cacheRequest, odiAdapter, rsMeta);
        }
        return this.resultSetCache;
    }

    ResultSetCache getResultSetCache(CacheRequest cacheRequest, IRowResultSet rowResultSet, IResultClass rsMeta) throws DataException {
        this.eventHandler = cacheRequest.getEventHandler();
        this.populateData(rowResultSet, rsMeta, cacheRequest.getSortSpec());
        return this.resultSetCache;
    }

    private void initInstance(CacheRequest cacheRequest, OdiAdapter odiAdpater, IResultClass rsMeta) throws DataException {
        this.eventHandler = cacheRequest.getEventHandler();
        ExpandableRowResultSet rowResultSet = new ExpandableRowResultSet(new SmartCacheRequest(cacheRequest.getMaxRow(), cacheRequest.getFetchEvents(), odiAdpater, rsMeta, cacheRequest.getDistinctValueFlag()));
        this.populateData(rowResultSet, rsMeta, cacheRequest.getSortSpec());
    }

    private void populateData(IRowResultSet rowResultSet, IResultClass rsMeta, SortSpec sortSpec) throws DataException {
        IResultObject[] resultObjects;
        IResultObject odaObject;
        long startTime = System.currentTimeMillis();
        SizeOfUtil sizeOfUtil = new SizeOfUtil(rsMeta);
        long memoryCacheSize = CacheUtil.computeMemoryBufferSize(this.eventHandler.getAppContext());
        int maxRows = CacheUtil.getMaxRows(this.eventHandler.getAppContext());
        ArrayList<IResultObject> resultObjectsList = new ArrayList<IResultObject>();
        int dataCount = 0;
        long usedMemorySize = 0L;
        while (!this.session.getStopSign().isStopped() && (odaObject = rowResultSet.next()) != null) {
            if (memoryCacheSize == 0L || usedMemorySize < memoryCacheSize) {
                int metaFieldCount;
                if (maxRows > 0 && ++dataCount > maxRows) {
                    throw new DataException("data.engine.exceed.max.data.object.row");
                }
                int odaObjectFieldCount = odaObject.getResultClass().getFieldCount();
                if (odaObjectFieldCount < (metaFieldCount = rsMeta.getFieldCount())) {
                    Object[] obs = new Object[metaFieldCount];
                    int i = 1;
                    while (i <= odaObjectFieldCount) {
                        obs[i - 1] = odaObject.getFieldValue(i);
                        ++i;
                    }
                    ResultObject temp = new ResultObject(rsMeta, obs);
                    resultObjectsList.add(temp);
                    if (memoryCacheSize == 0L) continue;
                    usedMemorySize += (long)sizeOfUtil.sizeOf(temp);
                    continue;
                }
                resultObjectsList.add(odaObject);
                if (memoryCacheSize == 0L) continue;
                usedMemorySize += (long)sizeOfUtil.sizeOf(odaObject);
                continue;
            }
            logger.fine("DisckCache is used");
            resultObjects = resultObjectsList.toArray(new IResultObject[0]);
            this.resultSetCache = new DiskCache(resultObjects, odaObject, rowResultSet, rsMeta, SmartCacheHelper.getComparator(sortSpec, this.eventHandler), dataCount, maxRows, this.session);
            break;
        }
        if (this.resultSetCache == null) {
            logger.fine("MemoryCache is used");
            resultObjects = resultObjectsList.toArray(new IResultObject[0]);
            this.resultSetCache = new MemoryCache(resultObjects, rsMeta, SmartCacheHelper.getComparator(sortSpec, this.eventHandler));
        }
        odaObject = null;
        resultObjects = null;
        resultObjectsList = null;
        rowResultSet = null;
        long consumedTime = (System.currentTimeMillis() - startTime) / 1000L;
        logger.fine("Time consumed by cache is: " + consumedTime + " second");
    }

    private static Comparator getComparator(SortSpec sortSpec, final IEventHandler eventHandler) {
        if (sortSpec == null) {
            return null;
        }
        final int[] sortKeyIndexes = sortSpec.getSortKeyIndexes();
        final String[] sortKeyColumns = sortSpec.getSortKeyColumns();
        if (sortKeyIndexes == null || sortKeyIndexes.length == 0) {
            return null;
        }
        final int[] sortAscending = sortSpec.getSortAscending();
        final CompareHints[] comparators = sortSpec.getComparator();
        Comparator comparator = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                IResultObject row1 = (IResultObject)obj1;
                IResultObject row2 = (IResultObject)obj2;
                int i = 0;
                while (i < sortKeyIndexes.length) {
                    block6: {
                        int result;
                        block7: {
                            int colIndex = sortKeyIndexes[i];
                            String colName = sortKeyColumns[i];
                            try {
                                Object colObj1 = null;
                                Object colObj2 = null;
                                if (eventHandler != null) {
                                    colObj1 = eventHandler.getValue(row1, colIndex, colName);
                                    colObj2 = eventHandler.getValue(row2, colIndex, colName);
                                } else {
                                    colObj1 = row1.getFieldValue(colIndex);
                                    colObj2 = row2.getFieldValue(colIndex);
                                }
                                result = ScriptEvalUtil.compare(colObj1, colObj2, comparators[i]);
                                if (result == 0) break block6;
                                if (sortAscending[i] != -1) break block7;
                                return 0;
                            }
                            catch (DataException dataException) {}
                        }
                        return sortAscending[i] == 0 ? result : -result;
                    }
                    ++i;
                }
                return 0;
            }
        };
        return comparator;
    }
}

