/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.trust.message.token;

import javax.xml.namespace.QName;
import org.apache.ws.security.trust.WSTrustException;
import org.apache.ws.security.trust.message.token.CompositeElement;
import org.apache.ws.security.trust.message.token.RequestType;
import org.apache.ws.security.trust.message.token.TokenType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class RequestSecurityToken
extends CompositeElement {
    protected TokenType tokenTypeElement;
    protected RequestType requestTypeElement;
    public static final QName TOKEN = new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestSecurityToken", "wst");

    public RequestSecurityToken(Document doc, String requestType) {
        super(doc);
        this.setRequestType(requestType);
    }

    public RequestSecurityToken(Element elem) throws WSTrustException {
        super(elem);
    }

    public void setTokenType(String tokenType) {
        if (this.tokenTypeElement == null) {
            this.tokenTypeElement = new TokenType(this.element.getOwnerDocument());
            this.element.appendChild(this.tokenTypeElement.getElement());
        }
        this.tokenTypeElement.setValue(tokenType);
    }

    public String getTokenType() {
        if (this.tokenTypeElement != null) {
            return this.tokenTypeElement.getValue();
        }
        return null;
    }

    public void setRequestType(String requestType) {
        if (this.requestTypeElement == null) {
            this.requestTypeElement = new RequestType(this.element.getOwnerDocument());
            this.element.appendChild(this.requestTypeElement.getElement());
        }
        this.requestTypeElement.setValue(requestType);
    }

    public String getRequesType() {
        if (this.requestTypeElement != null) {
            return this.requestTypeElement.getValue();
        }
        return null;
    }

    public void setContextAttr(String contextAttrValue) {
        this.element.setAttribute("Context", contextAttrValue);
    }

    public void addToken(Element childToken) {
        this.element.appendChild(childToken);
    }

    public void addAttribute(String attribute, String value) {
        this.element.setAttribute(attribute, value);
    }

    public NodeList getTokensByTagNameNS(String namespace, String tagName) {
        return this.element.getElementsByTagNameNS(namespace, tagName);
    }

    public String getAttributeValue(String attribute) {
        return this.element.getAttribute(attribute);
    }

    protected QName getToken() {
        return TOKEN;
    }

    public Element getElement() {
        return this.element;
    }

    protected void deserializeChildElement(Element elem) throws WSTrustException {
        QName el = new QName(elem.getNamespaceURI(), elem.getLocalName());
        if (el.equals(RequestType.TOKEN)) {
            this.requestTypeElement = new RequestType(elem);
        } else if (el.equals(TokenType.TOKEN)) {
            this.tokenTypeElement = new TokenType(elem);
        } else {
            this.handleSpecificChildren(elem);
        }
    }

    protected abstract void handleSpecificChildren(Element var1) throws WSTrustException;
}

