/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.trust.message.token;

import javax.xml.namespace.QName;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.trust.WSTrustException;
import org.apache.ws.security.trust.message.token.AllowPostdating;
import org.apache.ws.security.trust.message.token.Lifetime;
import org.apache.ws.security.trust.message.token.RenewTarget;
import org.apache.ws.security.trust.message.token.RequestSecurityToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RenewRequestSecurityToken
extends RequestSecurityToken {
    private RenewTarget renewTargetElement;
    private AllowPostdating allowPostdatingElement;
    private Lifetime lifetimeElement;

    public RenewRequestSecurityToken(Document doc) {
        super(doc, "http://schemas.xmlsoap.org/ws/2005/02/trust/Renew");
    }

    public RenewRequestSecurityToken(Element elem) throws WSTrustException {
        super(elem);
    }

    public void setRenewTarget(Element tokenBeingRenewed) {
        if (this.renewTargetElement == null) {
            this.renewTargetElement = new RenewTarget(this.document);
            this.addChild(this.renewTargetElement);
        }
        this.renewTargetElement.setTokenToBeRenewed(tokenBeingRenewed);
    }

    public void setRenewTarget(SecurityTokenReference securityTokenReference) {
        if (this.renewTargetElement == null) {
            this.renewTargetElement = new RenewTarget(this.document);
            this.addChild(this.renewTargetElement);
        }
        this.renewTargetElement.setSecurityTokenReference(securityTokenReference);
    }

    public void setAllowPostdating() {
        if (this.allowPostdatingElement == null) {
            this.allowPostdatingElement = new AllowPostdating(this.document);
            this.addChild(this.allowPostdatingElement);
        }
    }

    protected void handleSpecificChildren(Element elem) throws WSTrustException {
        QName el = new QName(elem.getNamespaceURI(), elem.getLocalName());
        if (el.equals(RenewTarget.TOKEN)) {
            this.renewTargetElement = new RenewTarget(elem);
        } else if (el.equals(AllowPostdating.TOKEN)) {
            this.allowPostdatingElement = new AllowPostdating(elem);
        } else if (el.equals(Lifetime.TOKEN)) {
            this.lifetimeElement = new Lifetime(elem);
        } else {
            throw new WSTrustException("InvalidRequest", "incorrectChildElement", new Object[]{TOKEN.getPrefix(), TOKEN.getLocalPart(), el.getNamespaceURI(), el.getLocalPart()});
        }
    }
}

