/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.trust.message.token;

import javax.xml.namespace.QName;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BaseToken {
    public static final QName TOKEN = new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "Base", "wst");
    Element element;

    public BaseToken(Element elem) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(4, "badTokenType:base", new Object[]{el});
        }
    }

    public BaseToken(Document doc) {
        this.element = doc.createElementNS(TOKEN.getNamespaceURI(), TOKEN.getPrefix() + ":" + TOKEN.getLocalPart());
        WSSecurityUtil.setNamespace(this.element, TOKEN.getNamespaceURI(), "wst");
        this.element.appendChild(doc.createTextNode(""));
    }

    public BinarySecurity getBinarySecurityToken() throws WSSecurityException {
        BinarySecurity binarySecToken = null;
        String firstChild = this.element.getFirstChild().getLocalName();
        if ("BinarySecurityToken" == firstChild) {
            binarySecToken = new BinarySecurity(WSSConfig.getDefaultWSConfig(), (Element)this.element.getFirstChild());
            return binarySecToken;
        }
        if ("SecurityTokenReference" == firstChild) {
            SecurityTokenReference secTokRef = new SecurityTokenReference(WSSConfig.getDefaultWSConfig(), (Element)this.element.getFirstChild());
            binarySecToken = new BinarySecurity(WSSConfig.getDefaultWSConfig(), secTokRef.getTokenElement(this.element.getOwnerDocument(), null));
            return binarySecToken;
        }
        throw new WSSecurityException(4, "badTokenType");
    }

    public void setBinarySecurityToken(BinarySecurity binarySecurity) {
        Element elem = this.getFirstElement();
        if (elem != null) {
            this.element.replaceChild(binarySecurity.getElement(), elem);
        } else {
            this.element.appendChild(binarySecurity.getElement());
        }
    }

    public Element getFirstElement() {
        for (Node currentChild = this.element.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (!(currentChild instanceof Element)) continue;
            return (Element)currentChild;
        }
        return null;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public void addToken(Element childToken) {
        this.element.appendChild(childToken);
    }

    public void removeToken(Element childToken) {
        this.element.removeChild(childToken);
    }
}

