/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.trust;

import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.policy.message.token.AppliesTo;
import org.apache.ws.security.trust.WSTrustException;
import org.apache.ws.security.trust.message.token.BinarySecret;
import org.apache.ws.security.trust.message.token.ComputedKey;
import org.apache.ws.security.trust.message.token.Entropy;
import org.apache.ws.security.trust.message.token.RequestSecurityTokenResponse;
import org.apache.ws.security.trust.message.token.RequestedProofToken;
import org.apache.ws.security.trust.message.token.RequestedSecurityToken;
import org.apache.ws.security.trust2.Lifetime;
import org.apache.xml.utils.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RSTRParser {
    private Element element = null;
    private AppliesTo appto = null;
    private Lifetime lifeTime = null;
    private RequestedSecurityToken reqtedTok = null;
    private RequestedProofToken proofTok = null;
    private Entropy entropy = null;
    private ComputedKey ckey = null;
    private BinarySecret binSecret = null;
    private static final QName APPLIES_TO = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "AppliesTo");
    private static final QName LIFE_TIME = new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "Lifetime");
    private static final QName REQUESTED_ST = new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestedSecurityToken");
    private static final QName PROOF_TOKEN = new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestedProofToken");
    private static final QName ENTROPY = new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "Entropy");
    private static final QName COMPUTED_KEY = new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "ComputedKey");
    private static final QName BIN_SECRET = new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "BinarySecret");

    public void processRSTR(RequestSecurityTokenResponse rstr) throws WSTrustException, WSSecurityException {
    }

    private void handleProofToken() throws WSTrustException, WSSecurityException {
        NodeList list = this.proofTok.getElement().getChildNodes();
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Node val;
            Node nod = list.item(i);
            if (nod.getNodeType() != 1) continue;
            Element elem = (Element)nod;
            QName el = new QName(elem.getNamespaceURI(), elem.getLocalName());
            if (el.equals((Object)COMPUTED_KEY)) {
                this.ckey = new ComputedKey(elem);
                val = elem.getChildNodes().item(0);
                if (val.getNodeType() == 3) {
                    this.ckey.setComputedKeyValue(val.getNodeValue());
                    continue;
                }
                throw new WSTrustException("Parser Exception");
            }
            if (!el.equals((Object)BinarySecret.TOKEN)) continue;
            this.binSecret = new BinarySecret(elem);
            val = elem.getChildNodes().item(0);
            if (val.getNodeType() == 3) {
                this.binSecret.setValue(val.getNodeValue());
                continue;
            }
            throw new WSTrustException("Parser Exception");
        }
    }

    private void handleEntropy() throws WSTrustException, WSSecurityException {
    }

    public AppliesTo getAppto() {
        return this.appto;
    }

    public BinarySecret getBinSecret() {
        return this.binSecret;
    }

    public ComputedKey getCkey() {
        return this.ckey;
    }

    public Entropy getEntropy() {
        return this.entropy;
    }

    public Lifetime getLifeTime() {
        return this.lifeTime;
    }

    public RequestedProofToken getProofTok() {
        return this.proofTok;
    }

    public RequestedSecurityToken getReqtedTok() {
        return this.reqtedTok;
    }

    public void setAppto(AppliesTo to) {
        this.appto = to;
    }

    public void setBinSecret(BinarySecret secret) {
        this.binSecret = secret;
    }

    public void setCkey(ComputedKey key) {
        this.ckey = key;
    }

    public void setEntropy(Entropy entropy) {
        this.entropy = entropy;
    }

    public void setLifeTime(Lifetime lifetime) {
        this.lifeTime = lifetime;
    }

    public void setProofTok(RequestedProofToken token) {
        this.proofTok = token;
    }

    public void setReqtedTok(RequestedSecurityToken token) {
        this.reqtedTok = token;
    }
}

