/*
 * Decompiled with CFR 0.152.
 */
package org.compass.spring.web.mvc;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.compass.core.CompassCallback;
import org.compass.core.CompassDetachedHits;
import org.compass.core.CompassException;
import org.compass.core.CompassHits;
import org.compass.core.CompassQuery;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.spring.web.mvc.AbstractCompassCommandController;
import org.compass.spring.web.mvc.CompassSearchCommand;
import org.compass.spring.web.mvc.CompassSearchResults;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;

public class CompassSearchController
extends AbstractCompassCommandController {
    private String searchView;
    private String searchResultsView;
    private String searchResultsName = "searchResults";
    private Integer pageSize;

    public CompassSearchController() {
        this.setCommandClass(CompassSearchCommand.class);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.searchView == null) {
            throw new IllegalArgumentException("Must set the searchView property");
        }
        if (this.searchResultsView == null) {
            throw new IllegalArgumentException("Must set the serachResultsView property");
        }
    }

    protected ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        final CompassSearchCommand searchCommand = (CompassSearchCommand)command;
        if (!StringUtils.hasText((String)searchCommand.getQuery())) {
            return new ModelAndView(this.getSearchView(), this.getCommandName(), (Object)searchCommand);
        }
        CompassSearchResults searchResults = (CompassSearchResults)this.getCompassTemplate().execute(CompassTransaction.TransactionIsolation.READ_ONLY_READ_COMMITTED, new CompassCallback(){

            public Object doInCompass(CompassSession session) throws CompassException {
                return CompassSearchController.this.performSearch(searchCommand, session);
            }
        });
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(this.getCommandName(), searchCommand);
        data.put(this.getSearchResultsName(), searchResults);
        return new ModelAndView(this.getSearchResultsView(), data);
    }

    protected CompassSearchResults performSearch(CompassSearchCommand searchCommand, CompassSession session) {
        CompassDetachedHits detachedHits;
        long time = System.currentTimeMillis();
        CompassQuery query = this.buildQuery(searchCommand, session);
        CompassHits hits = query.hits();
        CompassSearchResults.Page[] pages = null;
        if (this.pageSize == null) {
            this.doProcessBeforeDetach(searchCommand, session, hits, -1, -1);
            detachedHits = hits.detach();
            this.doProcessAfterDetach(searchCommand, session, detachedHits);
        } else {
            CompassSearchResults.Page lastPage;
            int from;
            int iPageSize = this.pageSize;
            int page = 0;
            int hitsLength = hits.getLength();
            if (searchCommand.getPage() != null) {
                page = searchCommand.getPage();
            }
            if ((from = page * iPageSize) > hits.getLength()) {
                from = hits.getLength() - iPageSize;
                this.doProcessBeforeDetach(searchCommand, session, hits, from, hitsLength);
                detachedHits = hits.detach(from, hitsLength);
            } else if (from + iPageSize > hitsLength) {
                this.doProcessBeforeDetach(searchCommand, session, hits, from, hitsLength);
                detachedHits = hits.detach(from, hitsLength);
            } else {
                this.doProcessBeforeDetach(searchCommand, session, hits, from, iPageSize);
                detachedHits = hits.detach(from, iPageSize);
            }
            this.doProcessAfterDetach(searchCommand, session, detachedHits);
            int numberOfPages = (int)Math.ceil((float)hitsLength / (float)iPageSize);
            pages = new CompassSearchResults.Page[numberOfPages];
            for (int i = 0; i < pages.length; ++i) {
                pages[i] = new CompassSearchResults.Page();
                pages[i].setFrom(i * iPageSize + 1);
                pages[i].setSize(iPageSize);
                pages[i].setTo((i + 1) * iPageSize);
                if (from >= pages[i].getFrom() - 1 && from < pages[i].getTo()) {
                    pages[i].setSelected(true);
                    continue;
                }
                pages[i].setSelected(false);
            }
            if (numberOfPages > 0 && (lastPage = pages[numberOfPages - 1]).getTo() > hitsLength) {
                lastPage.setSize(hitsLength - lastPage.getFrom());
                lastPage.setTo(hitsLength);
            }
        }
        time = System.currentTimeMillis() - time;
        CompassSearchResults searchResults = new CompassSearchResults(detachedHits.getHits(), time);
        searchResults.setPages(pages);
        return searchResults;
    }

    protected CompassQuery buildQuery(CompassSearchCommand searchCommand, CompassSession session) {
        return session.queryBuilder().queryString(searchCommand.getQuery().trim()).toQuery();
    }

    protected void doProcessBeforeDetach(CompassSearchCommand searchCommand, CompassSession session, CompassHits hits, int from, int size) {
    }

    protected void doProcessAfterDetach(CompassSearchCommand searchCommand, CompassSession session, CompassDetachedHits hits) {
    }

    public String getSearchView() {
        return this.searchView;
    }

    public void setSearchView(String searchView) {
        this.searchView = searchView;
    }

    public String getSearchResultsName() {
        return this.searchResultsName;
    }

    public void setSearchResultsName(String searchResultsName) {
        this.searchResultsName = searchResultsName;
    }

    public String getSearchResultsView() {
        return this.searchResultsView;
    }

    public void setSearchResultsView(String resultsView) {
        this.searchResultsView = resultsView;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}

