/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.entities;

import java.util.ArrayList;
import javax.persistence.Entity;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Inheritance;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.spi.InternalCompass;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.StringUtils;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.entities.EntityInformation;
import org.compass.gps.device.jpa.entities.JpaEntitiesLocator;
import org.compass.gps.spi.CompassGpsInterfaceDevice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJpaEntitiesLocator
implements JpaEntitiesLocator {
    protected Log log = LogFactory.getLog(this.getClass());

    @Override
    public EntityInformation[] locate(EntityManagerFactory entityManagerFactory, JpaGpsDevice device) throws JpaGpsDeviceException {
        CompassGpsInterfaceDevice gps = (CompassGpsInterfaceDevice)device.getGps();
        ResourceMapping[] resourceMappings = ((InternalCompass)gps.getIndexCompass()).getMapping().getRootMappings();
        ArrayList<EntityInformation> entitiesList = new ArrayList<EntityInformation>(resourceMappings.length);
        for (ResourceMapping resourceMapping : resourceMappings) {
            EntityInformation entityInformation;
            ClassMapping classMapping;
            if (!(resourceMapping instanceof ClassMapping) || !(classMapping = (ClassMapping)resourceMapping).isRoot() || (entityInformation = this.createEntityInformation(classMapping.getClazz())) == null || this.shouldFilter(entityInformation, device)) continue;
            entitiesList.add(entityInformation);
        }
        return entitiesList.toArray(new EntityInformation[entitiesList.size()]);
    }

    protected EntityInformation createEntityInformation(Class<?> clazz) throws JpaGpsDeviceException {
        Entity entity = clazz.getAnnotation(Entity.class);
        if (entity == null) {
            return null;
        }
        String name = StringUtils.hasLength(entity.name()) ? entity.name() : ClassUtils.getShortName(clazz);
        return new EntityInformation(clazz, name);
    }

    protected boolean shouldFilter(EntityInformation entityInformation, JpaGpsDevice device) {
        for (Class<?> clazz = entityInformation.getEntityClass().getSuperclass(); clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            if (!clazz.isAnnotationPresent(Inheritance.class) || !((CompassGpsInterfaceDevice)device.getGps()).hasMappingForEntityForIndex(clazz)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Entity [" + entityInformation.getEntityName() + "] is inherited and super class [" + clazz + "] has compass mapping, filtering it out"));
            }
            return true;
        }
        return false;
    }
}

