/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.reader;

import java.io.IOException;
import java.io.Reader;
import org.compass.core.engine.RepeatableReader;

public class ReverseStringReader
extends Reader
implements RepeatableReader {
    private String str;
    private int next = 0;
    private int mark = 0;

    public ReverseStringReader(String s) {
        this.str = s;
        this.next = s.length();
    }

    public int read() throws IOException {
        if (this.next <= 0) {
            return -1;
        }
        return this.str.charAt(--this.next);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.next <= 0) {
            return -1;
        }
        int n = Math.min(this.next, len);
        for (int i = 0; i < n; ++i) {
            cbuf[off + i] = (char)this.read();
        }
        return n;
    }

    public long skip(long ns) throws IOException {
        if (this.next <= 0) {
            return 0L;
        }
        long n = Math.min((long)this.next, ns);
        this.next = (int)((long)this.next - n);
        return n;
    }

    public boolean ready() throws IOException {
        return true;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.mark = this.next;
    }

    public void reset() throws IOException {
        this.next = this.mark;
    }

    public void close() {
        this.next = this.str.length();
    }
}

