/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util.backport.java.util.concurrent.atomic;

import java.io.Serializable;

public class AtomicIntegerArray
implements Serializable {
    private static final long serialVersionUID = 2862133569453604235L;
    private final int[] array;

    public AtomicIntegerArray(int length) {
        this.array = new int[length];
    }

    public AtomicIntegerArray(int[] array) {
        if (array == null) {
            throw new NullPointerException();
        }
        int length = array.length;
        this.array = new int[length];
        System.arraycopy(array, 0, this.array, 0, array.length);
    }

    public final int length() {
        return this.array.length;
    }

    public final synchronized int get(int i) {
        return this.array[i];
    }

    public final synchronized void set(int i, int newValue) {
        this.array[i] = newValue;
    }

    public final synchronized void lazySet(int i, int newValue) {
        this.array[i] = newValue;
    }

    public final synchronized int getAndSet(int i, int newValue) {
        int old = this.array[i];
        this.array[i] = newValue;
        return old;
    }

    public final synchronized boolean compareAndSet(int i, int expect, int update) {
        if (this.array[i] == expect) {
            this.array[i] = update;
            return true;
        }
        return false;
    }

    public final synchronized boolean weakCompareAndSet(int i, int expect, int update) {
        if (this.array[i] == expect) {
            this.array[i] = update;
            return true;
        }
        return false;
    }

    public final synchronized int getAndIncrement(int i) {
        int n = i;
        int n2 = this.array[n];
        this.array[n] = n2 + 1;
        return n2;
    }

    public final synchronized int getAndDecrement(int i) {
        int n = i;
        int n2 = this.array[n];
        this.array[n] = n2 - 1;
        return n2;
    }

    public final synchronized int getAndAdd(int i, int delta) {
        int old = this.array[i];
        int n = i;
        this.array[n] = this.array[n] + delta;
        return old;
    }

    public final synchronized int incrementAndGet(int i) {
        int n = i;
        int n2 = this.array[n] + 1;
        this.array[n] = n2;
        return n2;
    }

    public final synchronized int decrementAndGet(int i) {
        int n = i;
        int n2 = this.array[n] - 1;
        this.array[n] = n2;
        return n2;
    }

    public final synchronized int addAndGet(int i, int delta) {
        int n = i;
        int n2 = this.array[n] + delta;
        this.array[n] = n2;
        return n2;
    }

    public synchronized String toString() {
        if (this.array.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        buf.append(this.array[0]);
        for (int i = 1; i < this.array.length; ++i) {
            buf.append(", ");
            buf.append(this.array[i]);
        }
        buf.append("]");
        return buf.toString();
    }
}

