/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.spi;

import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.engine.utils.ResourceHelper;
import org.compass.core.mapping.ResourceMapping;

public final class ResourceKey {
    private String alias;
    private Property[] ids;
    private int hashCode = Integer.MIN_VALUE;
    private ResourceMapping resourceMapping;

    public ResourceKey(ResourceMapping resourceMapping, Resource idResource) {
        this(resourceMapping, ResourceHelper.toIds(idResource, resourceMapping));
    }

    public ResourceKey(ResourceMapping resourceMapping, Property[] ids) {
        this.resourceMapping = resourceMapping;
        this.ids = ids;
        this.alias = resourceMapping.getAlias();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        ResourceKey key = (ResourceKey)other;
        if (!key.alias.equals(this.alias)) {
            return false;
        }
        for (int i = 0; i < this.ids.length; ++i) {
            if (key.ids[i].getStringValue().equals(this.ids[i].getStringValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == Integer.MIN_VALUE) {
            this.hashCode = this.getHashCode();
        }
        return this.hashCode;
    }

    public String getAlias() {
        return this.alias;
    }

    public Property[] getIds() {
        return this.ids;
    }

    public ResourceMapping getResourceMapping() {
        return this.resourceMapping;
    }

    private int getHashCode() {
        int result = this.alias.hashCode();
        for (int i = 0; i < this.ids.length; ++i) {
            result = 29 * result + this.ids[i].getStringValue().hashCode();
        }
        return result;
    }
}

